<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Marcolin\Listeners;


use Marcolin\Events\UserWasRegistered;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Support\Facades\Mail;

/**
 * Sends an email to customer service to alert that a new user was created.
 *
 * Class EmailNewUserAlert
 * @package Marcolin\Listeners
 */
class EmailNewUserAlert {

    public function construct() {

    }

    public function handle(UserWasRegistered $event) {
        if ($event->selfCreated) {
            Mail::send('marcolin::emails.newUserAlert', ['webUser' => $event->webUser], function ($mail) use ($event) {
                foreach (config('marcolin.emailDestinations.newUserAlert.to', []) as $to) {
                    if (strlen($to)) $mail->to($to);
                }

                foreach (config('marcolin.emailDestinations.newUserAlert.bcc', []) as $bcc) {
                    if (strlen($bcc)) $mail->bcc($bcc);
                }

                $mail->from(config('mail.from_registration.address'), config('mail.from_registration.name'));

                $mail->subject(trans('marcolin::email.newUserAlertSubject', ['customerNumber' => $event->webUser->customer->customerCode]));
            });
        }
    }
}