<?php

namespace Marcolin\Models;

use Illuminate\Support\Facades\Auth;
use DB;

/**
 * Marcolin\Models\WebLink
 *
 * @property integer $id
 * @property integer $web_link_category_id
 * @property string $links
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebLink extends WebModel {
    protected $table = "WebLinks";
    protected $fillable = ['user_visibility', 'link','type','order','display_name','webSiloIds','web_link_category_id'];
    public static $userVisibility;
    public static $types;
    public static $typeValues = [
        'landing_page',
        'asset',
        'general',
    ];

    function __construct($attributes = array())
    {
        parent::__construct($attributes);

        self::$userVisibility = [
            trans('marcolin::app.hidden'),
            trans('marcolin::app.visible_for_all'),
            trans('marcolin::app.for_anonymous_user'),
            trans('marcolin::app.for_logged_in_user')
        ];

        self::$types = [
            'landing_page' => trans('marcolin::app.landing_page'),
            'asset' => trans('marcolin::app.asset'),
            'general' => trans('marcolin::app.any_url'),
        ];
    }

    public function webSilos() {
        return $this->belongsToMany(WebSilo::class, 'WebLink_WebSilo', 'weblink_id', 'websilo_id');
    }

    public function category() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

    public function setWebSiloIdsAttribute($ids) {
        $this->save();
        $this->webSilos()->sync($ids);
    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('marcolin.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

    public function scopeAvailableForUser($query){
        $user = Auth::user();
        if(isset($user)){
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',3);
            });
        }else{
            $query = $query->where(function($query){
                return $query->where('WebLinks.user_visibility',1)->orWhere('WebLinks.user_visibility',2);
            });
        }
        return $query
            ->leftJoin('WebLink_WebSilo as WLWS', 'WLWS.weblink_id', '=', 'WebLinks.id')
            ->leftJoin('WebSilos as WS', 'WS.id', '=', 'WLWS.websilo_id')
            ->select(DB::raw('WebLinks.*'));
    }

}
