<?php

namespace Marcolin\Models;

use Marcolin\SoftDeletes;


/**
 * Marcolin\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @mixin \Eloquent
 */
class SalesOrder extends UuidModel
{
    protected $table = "SalesOrders";

    use SoftDeletes;

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function promotions()
    {
        return $this->belongsToMany(Promotion::class, 'Promotion_SalesOrder', 'salesOrder_id', 'promotion_id');
    }

    public function getTotalSunglassPrice($customer)
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems()->with('unit.styleRelation')->get() as $salesOrderItem) {
            if ($salesOrderItem->unit != null && $salesOrderItem->unit->styleRelation->productType == 'S') {
                $totalQuantity += $salesOrderItem->quantity * $salesOrderItem->unit->getCustomerPrice($customer);
            }
        }
        return $totalQuantity;
    }

    public function getTotalSunglassQuantityAttribute()
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems()->with('unit.styleRelation')->get() as $salesOrderItem) {
            if ($salesOrderItem->unit != null && $salesOrderItem->unit->styleRelation->productType == 'S') {
                $totalQuantity += $salesOrderItem->quantity;
            }
        }
        return $totalQuantity;
    }

    public function getTotalOpticalPrice($customer)
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems()->with('unit.styleRelation')->get() as $salesOrderItem) {
            if ($salesOrderItem->unit != null && $salesOrderItem->unit->styleRelation->productType == 'V') {
                $totalQuantity += $salesOrderItem->quantity * $salesOrderItem->unit->getCustomerPrice($customer);
            }
        }
        return $totalQuantity;
    }

    public function getTotalOpticalQuantityAttribute()
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems()->with('unit.styleRelation')->get() as $salesOrderItem) {
            if ($salesOrderItem->unit != null && $salesOrderItem->unit->styleRelation->productType == 'V') {
                $totalQuantity += $salesOrderItem->quantity;
            }
        }
        return $totalQuantity;
    }

    public function getTotalPrice($customer)
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems as $salesOrderItem) {
            if ($salesOrderItem->unit != null) {
                $totalQuantity += $salesOrderItem->quantity * $salesOrderItem->unit->getCustomerPrice($customer);
            }
        }
        return $totalQuantity;
    }

    public function getTotalQuantityAttribute()
    {
        $totalQuantity = 0;
        foreach ($this->salesOrderItems as $salesOrderItem) {
            $totalQuantity += $salesOrderItem->quantity;
        }
        return $totalQuantity;
    }

    public function getCompleteNotesAttribute() {
        $notes = [];
        foreach ($this->salesOrderNotes as $salesOrderNote) {
            $notes[] = $salesOrderNote->orderNote;
        }
        return implode("\n", $notes);

    }

    public function salesOrderItems()
    {
        return $this->hasMany(SalesOrderItem::class, 'salesOrder_id', 'id');
    }

    public function salesOrderNotes()
    {
        return $this->hasMany(SalesOrderNote::class, 'salesOrder_id', 'id');
    }

    public function scopeDateBetween($query, $fromDate, $toDate = false)
    {
        if ($toDate === false) {
            $query->where('orderDate', '>=', $fromDate);
        } else {
            $query->whereBetween('orderDate', [$fromDate, $toDate]);
        }
        return $query;
    }

    public function scopeWebOrders($query)
    {
        return $query->where('orderType', 'B');
    }
}
