@if($edit)
    <div class="mceNonEditable component-container" data-component-key="jumbotron">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('marcolin::app.jumbotron')</h4>
        <p>@lang('marcolin::app.displays_a_large_banner_across_the_entire_width_of_the_page')</p>
        <img data-web-asset-id="{{ $webAssetId }}" id="jumbotronThumbnail" src="{{ webAssetUrl($webAssetId) }}" class="img-responsive center-block">
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('jumbotron', {
            menuText: '@lang('marcolin::app.jumbotron')',
            bladeTemplate: 'marcolin::components.jumbotron',
            init: function (body) {
                $(body).on('click', '#jumbotronThumbnail', function() {
                    assets.finder({
                        successFunction: function(data) {
                            $(body).find('img#jumbotronThumbnail')
                                    .attr('src', data.url)
                                    .attr('data-web-asset-id', data.id)
                            ;
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                return {
                    webAssetId: $(componentNode).find('img#jumbotronThumbnail').data('web-asset-id')
                }
            },
        });
    </script>
@endif

@if($view)
    <div class="row container center-block">
        <div class="col-xs-12">
            <img style="width: 100%;" class="img-responsive" src="{{webAssetUrl($webAssetId)}}" alt="">
        </div>
    </div>
    <br>
@endif
