@if(auth()->user())
<div class="col-md-6">
    <div class="panel panel-info">
        <div class="panel-heading">
            <h3 class="panel-title text-center">@lang('marcolin::app.rewards_status')</h3>
        </div>
        <div class="panel-body" style="height: 280px">
            <div class="h4 text-center">
                @lang('marcolin::app.your_marcolin_vision_loyalty_rewards_level_is')
            </div>
            <div class="rewardsBar">
                <div class="one">@lang('marcolin::app.one_caps')</div>
                <div class="bronze">@lang('marcolin::app.bronze_caps')</div>
                <div class="silver">@lang('marcolin::app.silver_caps')</div>
                <div class="gold active">@lang('marcolin::app.gold_caps')</div>
                <div class="one platinum">@lang('marcolin::app.platinum_caps')</div>
                <div class="clearfix"></div>
            </div>
            <br>
            <div>
                <div class="pull-right h3 nomargin">$2,680</div>
                <p>@lang('marcolin::app.last_12_months_qualifying_purchases') </p>
            </div>
            <div>
                <div class="pull-right h3 nomargin">3</div>
                <p>@lang('marcolin::app.last_12_months_qualified_categories') </p>
            </div>
            <div class="text-info">@lang('marcolin::app.continuous_marcolin_vision_loyalty_rewards_program_member_since') 8/20/16</div>
            <a href="#" class="btn btn-info">@lang('marcolin::app.details')</a>
        </div>
    </div>
</div>
<div class="col-md-6">
    <div class="panel panel-info">
        <div class="panel-heading">
            <h3 class="panel-title text-center">@lang('marcolin::app.recent_orders')</h3>
        </div>
        <div class="panel-body" style="height: 280px">
            <table class="table table-condensed">
                <thead>
                <tr>
                    <th>@lang('marcolin::app.order_number_hash')</th>
                    <th>@lang('marcolin::app.date')</th>
                    <th>@lang('marcolin::app.qty_dot')</th>
                    <th>@lang('marcolin::app.status')</th>
                </tr>
                </thead>
                <tbody>
                @foreach($lastOrders as $order)
                    <tr>
                        <td>{{ $order->marcolin_order_number }}</td>
                        <td>{{ $order->order_date }}</td>
                        <td>6</td>
                        <td>{{ $order->order_status }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('styles')
<style type="text/css">
    .rewardsBar {
        width: 100%;
        padding-bottom: 10px;
    }
    .rewardsBar .one,
    .rewardsBar .bronze,
    .rewardsBar .silver,
    .rewardsBar .gold,
    .rewardsBar .platinum {
        width: 20%;
        float: left;
        text-align: center;
        margin-top: 18px;
        padding: 5px;
        vertical-align: bottom;
    }
    .rewardsBar .one {
        background-color: green;
        color: white;
    }
    .rewardsBar .bronze {
        background-color: darkred;
        color: white;
    }
    .rewardsBar .silver {
        background-color: slategray;
        color: white;
    }
    .rewardsBar .gold {
        background-color: gold;
    }
    .rewardsBar .platinum {
        background-color: lightgray;
    }
    .rewardsBar .active {
        height: 50px;
        padding-top: 18px;
        margin-top: 0px;
    }

</style>
@endpush
@endif