<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Image as Image2;
use Storage;

/**
 * Marcolin\Models\Product
 *
 * @property mixed $id
 */
class Customer extends WebModel
{
	protected $table = 'Customers';

    public function brands() {
        return $this->belongsToMany(Brand::class, 'Brand_Customer');
    }

	public function salesData() {
	    return $this->hasMany(SalesData::class, 'customer_id', 'id');
    }

    public function orders() {
        return $this->hasMany(Order::class, 'soldTo_customer_id', 'id');
    }

    public function lastOrderedStyle($style) {
	    return $this->orderHistories->where('style', $style)->sortByDesc('billingDate')->first();
    }

    public function recentOrders($count = 5) {
        return $this
            ->orders()
//            ->submitted()
            ->with('orderItems')
            ->orderByDate()
            ->take($count)
            ->get();
    }

    public function topPurchasedItems($count = 5) {
        $data = $this
            ->salesData()
            ->with('unit.webUnit.webStyle')
            ->where(function ($wheres) {
                return $wheres
                    ->where('qtyB2B', '>', DB::raw(0))
                    ->orWhere('qtyIPad', '>', DB::raw(0))
                ;
            })
            ->whereHas('unit', function ($query) {
                return $query->whereHas('style', function ($query) {
                    return $query->whereHas('webStyle', function ($query) {
                        return $query->webVisible();
                    });
                });
            })
            ->groupBy('SalesData.id')
            ->orderBy('documentDate', 'desc')
            ->take($count)
            ->get()
        ;

        $styleIds = [];
        foreach ($data as $record) {
            $styleId = array_get($record, 'unit.webUnit.webStyle.id');
            $styleIds[$styleId] = $styleId;
        }
        return WebStyle::findMany($styleIds);
    }
//
//    public function topPurchasedItems($count = 5) {
//        $ids = WebFamily::visible()
//            ->join('WebParts', 'WebParts.webfamily_id', '=', 'WebFamilies.id')
//            ->join('SalesOrderPartLines', function($join) {
//                $join
//                    ->on('SalesOrderPartLines.part_id', '=', 'WebParts.part_id');
//            })
//            ->join('SalesOrderMainLines', function($join) {
//                $join
//                    ->on('SalesOrderMainLines.parent_id', '=', 'SalesOrderPartLines.id');
//            })
//            ->join('SalesOrders', function($join) {
//                $join
//                    ->on('SalesOrderPartLines.salesorder_id', '=', 'SalesOrders.id')
//                    ->on('SalesOrderMainLines.salesorder_id', '=', 'SalesOrders.id');
//            })
//            ->leftJoin('SalesOrderLineSchedules', function($join) {
//                $join
//                    ->on('SalesOrderLineSchedules.salesorder_id', '=', 'SalesOrders.id')
//                    ->on('SalesOrderLineSchedules.salesordermainline_id', '=', 'SalesOrderMainLines.id');
//            })
//            ->where('SalesOrders.deleted_at', '=', DB::raw('0'))
//            ->where('SalesOrderMainLines.deleted_at', '=', DB::raw('0'))
//            ->where('SalesOrderPartLines.deleted_at', '=', DB::raw('0'))
//            ->where(function ($where) {
//                $where
//                    ->whereNull('SalesOrderLineSchedules.deleted_at')
//                    ->orWhere('SalesOrderLineSchedules.deleted_at', '=', DB::raw('0'))
//                ;
//            })
//            ->where('SalesOrders.soldto_customer_id', '=', $this->id)
//            ->whereNotIn('SalesOrders.order_status', ['CANCELLED', 'DISCARDED'])
//            ->groupBy('WebFamilies.id')
//            ->orderBy(DB::raw('COUNT(DISTINCT SalesOrders.id)'), 'DESC')
//            ->take($count)
//            ->pluck('WebFamilies.id')
//        ;
//
//        return WebFamily::with('assets', 'visibleWebParts')->findMany($ids);
//    }
}

