<?php

namespace Hilco\Models;

use DB;

/**
 * Hilco\Models\WebDetailTab
 *
 * @property integer $id
 * @property string $name
 * @property string $body
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebDetailTab extends WebModel
{
    protected $table = "WebDetailTabs";
    protected $fillable = ['name','body'];

    public function webStyles() {
        return $this->belongsToMany(WebStyle::class, 'WebDetailTab_WebStyle', 'webdetailtab_id', 'webstyle_id')->withPivot('is_visible');
    }

}
