<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class AutocatCatalogUnit extends WebModel
{
    protected $table = "AutocatCatalogUnits";
    protected $fillable = [
        'autocatcatalog_id',
        'autocatcatalogstyle_id',
        'unit_id',
        'default_status',
        'override_status',
        'order',
        'primary_unit',
    ];

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatcatalog_id', 'id');
    }


    public function autocatCatalogStyle()
    {
        return $this->belongsTo(AutocatCatalogStyle::class, 'autocatcatalogstyle_id', 'id');
    }

    public function unit(){
        return$this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function comments()
    {
        return $this->belongsToMany(AutocatCatalogComment::class, 'AutocatCatalogUnit_AutocatCatalogComment', 'autocatcatalogunit_id', 'comment_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function defaultVisibility(){
        if($this->default_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function getDefaultStatusAttribute()
    {
        return $this->attributes['default_status'];
    }

    public function getOverrideStatusAttribute()
    {
        return $this->attributes['override_status'];
    }

    public function isDefaultShow(){
        if($this->default_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function isDefaultHide(){
        if($this->default_status === 0){
            return true;
        }else{
            return false;
        }
    }


    public function isOverrideShow(){
        if($this->override_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function isOverrideHide(){
        if($this->override_status === 0){
            return true;
        }else{
            return false;
        }
    }

    public function currentVisibility(){
        if($this->override_status === 1){
            return true;
        }else if($this->default_status === 1 && $this->override_status === null){
            return true;
        }else{
            return false;
        }
    }

    public function getColorAttribute(){
        return $this->unit->color;
    }

    public function getSizeAttribute(){
        return $this->unit->size;
    }

    public function scopeVisible( $query)
    {
        $query->where(function($q){
            return $q->where("override_status", "=",1)
                ->orWhere(function($q){
                    return $q->where("default_status", "=", 1)
                        ->whereNull("override_status");
                });
        });
        return $query;
    }

    public function getInCatalogAttribute() {
        return $this->override_status === 1 || ($this->override_status === null && $this->default_status === 1);
    }
}
