<?php
namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Upload extends WebModel {

    protected $table = "CMSUploads";
    protected $fillable = ['type', 'path', 'original_filename'];
	//

    public function uploadable() {
        return $this->morphTo();
    }

    public function content() {
        return $this->belongsTo('Marcolin\Models\Content');
    }

    public function uploader() {
        return $this->belongsTo('Marcolin\Models\WebUser');
    }

    public function getContentsPath() {
        return "/upload/$this->id/contents";
    }

    public function getDownloadPath() {
        return "/upload/$this->id/download";
    }

    public function getViewPath() {
        return "/upload/$this->id/view";
    }

    public function fileContentType(){
        if (preg_match('/\.(mp4|m4v|webm)$/i', $this->original_filename)){
            return 'video';
        }else{
            return 'default';
        }
    }

    public function contents() {
        $s3 = \Storage::disk('s3');
        return $s3->get($this->path);
    }

    public function fetch($download = true) {
//        $s3 = \Storage::disk('s3');
//        return response()->file($s3->url($this->path));

        $s3FileKey = $this->path;
//        $s3FileKey = 's3/key/path/to/file.ext';
        $fileName = 'file.ext';

// Create temporary download link and redirect
        $adapter = \Storage::disk('s3')->getAdapter();
        $client = $adapter->getClient();
        $client->registerStreamWrapper();
        $object = $client->headObject([
            'Bucket' => $adapter->getBucket(),
            'Key' => /*$adapter->getPathPrefix() . */$s3FileKey,
        ]);
        /*************************************************************************
         * Set headers to allow browser to force a download
         */
        header('Last-Modified: '.$object['LastModified']);
        // header('Etag: '.$object['ETag']); # We are not implementing validation caching here, but we could!
        header('Accept-Ranges: '.$object['AcceptRanges']);
        header('Content-Length: '.$object['ContentLength']);
        header('Content-Type: '.$object['ContentType']);
        if ($download){
            header('Content-Disposition: attachment; filename='.$this->original_filename);
        }else{
            header('Content-Disposition: inline; filename='.$this->original_filename);
        }
        /*************************************************************************
         * Stream file to the browser
         */
        // Open a stream in read-only mode
        if (!($stream = fopen("s3://{$adapter->getBucket()}/{$s3FileKey}", 'r'))) {
            throw new \Exception('Could not open stream for reading file: ['.$s3FileKey.']');
        }
        // Check if the stream has more data to read
        while (!feof($stream)) {
            // Read 1024 bytes from the stream
            echo fread($stream, 1024);
        }
        // Be sure to close the stream resource when you're done with it
        fclose($stream);
    }

    public function shortFileName($length = 15) {
       return strlen($this->original_filename) > $length ? substr($this->original_filename,0,$length)."..." : $this->original_filename;
    }

//    public static function createFromUpload(UploadedFile $file) {
//        $path = $file->getClientOriginalName() . '_' . date('YmdHis');
//        Storage::disk('s3')->put($path, $file);
//        $cu = new self([
//            'type' => 'primary',
//            'path' => $path,
//            'original_filename' => $file->getClientOriginalName()
//        ]);
//        $cu = Auth::user()->uploads()->save($cu);
//        return $cu;
//    }
}
