<?php

namespace Marcolin\Models;


use Illuminate\Database\Eloquent\Collection;


class VirtualRepStyleList extends WebModel
{
    protected $table = "VirtualRepStyleLists";
    protected $fillable = [
        'stylelist_name',
        'stylelist_description',
        'createdby_webuser_id',
        'lasteditedby_webuser_id',
    ];

    function createdByUser()
    {
        return $this->belongsTo(WebUser::class, 'createdby_webuser_id', 'id');
    }

    function lastEditedByUser()
    {
        return $this->belongsTo(WebUser::class, 'lasteditedby_webuser_id', 'id');
    }

    function getStyleCount() {
        return Style_VirtualRepStyleList::where('virtualrepstylelist_id', $this->id)->count();
    }

    function getCustomerCount() {
        return Customer_VirtualRepStyleList::where('virtualrepstylelist_id', $this->id)->count();
    }

    function getViewCount() {
        return Customer_VirtualRepStyleList::where('virtualrepstylelist_id', $this->id)->where('viewed', 1)->count();
    }

    function getOrderCount() {
        return Customer_VirtualRepStyleList::where('virtualrepstylelist_id', $this->id)->where('ordered', 1)->count();
    }

    /**
     * Get ordered list of available microsites (WebSilo objects)
     * @return array|\Illuminate\Database\Eloquent\Collection|WebSilo[]
     */
    public static function selectList()
    {
        return
            self::orderBy('stylelist_name', 'ASC')->get();
    }

    function styles() {
        return $this
            ->belongsToMany(Style::class, 'Style_VirtualRepStyleList', 'virtualrepstylelist_id', 'style_id')
            ->withPivot('notes', 'default_unit_id', 'order', 'default_unit_id')
        ;

    }
}
