<?php

namespace Marcolin\Models;

/**
 * Class PromotionOrderValueTrigger_Product
 * @package Marcolin\Models
 */
class PromotionOrderValueTrigger_Product extends WebModel {
    protected $table = 'PromotionOrderValueTrigger_Product';
    protected $fillable = [
        'promotionordervaluetrigger_id',
        'product_id', 'product_type',
        'is_excluded',
    ];
    protected $casts = ['is_excluded' => 'boolean'];

    /**
     * Gets the relationship to the owning PromotionOrderValueTrigger row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionOrderValueTrigger() {
        return $this->belongsTo(PromotionOrderValueTrigger::class,
            'promotionordervaluetrigger_id', 'id');
    }


    // Scopes
    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionordervaluetrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }
}