<?php

namespace Marcolin\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


class Order extends WebModel
{
	protected $table = "Orders";

    function orderItems() {
        return $this->hasMany(OrderItem::class);
    }

    function soldToCustomer() {
        return $this->belongsTo(Customer::class, 'soldTo_customer_id', 'id');
    }

    function shipToCustomer() {
        return $this->belongsTo(Customer::class, 'shipTo_customer_id', 'id');
    }

    function scopeOrderByDate($query, $order = 'desc') {
        return $query
            ->join('OrderItems', 'OrderItems.order_id', '=', 'Orders.id')
            ->orderBy(DB::raw('MIN(OrderItems.documentDate)'), $order)
            ->groupBy('Orders.id')
            ->select('Orders.*')->addSelect(DB::raw('MIN(OrderItems.documentDate) as order_date'))
        ;
    }

    public function getTotalQuantityAttribute() {
        $total = 0;
        foreach ($this->orderItems as $item) {
            $total += $item->orderQuantity;
        }
        return $total;
    }
}
