<?php

namespace Marcolin\Models;


class Customer_WebSilo extends WebModel {
    protected $table = 'Customer_WebSilo';
    protected $fillable = [
        'customer_id', 'websilo_id',
        'is_approver', 'spending_limit', 'spending_period', 'minimum_order',
        'commit_sequence'
    ];

    use HasCommitSequence;

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function scopeCustomerWebSilo($query, $customer_id, $websilo_id) {
        return $query
            ->where('customer_id', $customer_id)
            ->where('websilo_id', $websilo_id)
        ;
    }

}