<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;


/**
 * Marcolin\Models\Brand
 *
 * @property integer $id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Brand whereDeletedAt($value)
 * @mixin \Eloquent
 */
class  Brand extends Model
{
    protected $table = "Brands";

    public function customers()
    {
        return $this->belongsToMany(Customer::class, 'Brand_Customer')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    function styles()
    {
        return $this->hasMany(Style::class);
    }

    public function webBrand()
    {
        return $this->hasMany(WebBrand::class);
    }

    public function getIsWebVisibleAttribute()
    {
        return static::webVisible()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleStandardAttribute()
    {
        return static::webVisibleStandard()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleHarleyDavidsonAttribute()
    {
        return static::webVisibleHarleyDavidson()->where('id', '=', $this->id)->count() > 0;
    }

    public function scopeWebVisible($query)
    {
        $query
            ->whereHas('styles', function ($query) {
                return $query->webVisible();
            });
        return $query;
    }

    public function scopeWebVisibleStandard($query)
    {
        $query
            ->whereHas('styles', function ($query) {
                return $query->webVisibleStandard();
            });
        return $query;
    }

    public function scopeWebVisibleHarleyDavidson($query)
    {
        $query
            ->whereHas('styles', function ($query) {
                return $query->webVisibleHarleyDavidson();
            });
        return $query;
    }

    public function getNameAttribute()
    {
        return $this->brandName;
    }

    public function getOrderableAttribute($customer = false)
    {
        if (!isset($customer) || $customer === false) {
            $activeCustomer = b2b()->activeCustomer()->parentCustomer;
            if ($activeCustomer) {
                $customer = $activeCustomer;
            }
        }

        if ($customer !== false) {
            return $customer->brands->where('id', $this->id)->count() > 0;
        } else {
            return false;
        }
    }

    public function scopeForCustomer($query, $customer = false)
    {
        if ($customer === false) {
            $activeCustomer = b2b()->activeCustomer()->parentCustomer;
            if ($activeCustomer) {
                $customer = $activeCustomer;
            }
        }

        if ($customer !== false) {
            $query->whereHas('customers', function ($query) use ($customer) {
                $query->where('Customers.id', '=', $customer->id);
                return $query;
            });
        }

        return $query;
    }
}
