<?php

namespace Marcolin\Models;
use Marcolin\SoftDeletes;

/**
 * Marcolin\Models\SalesOrder_LocationData
 *
 * @mixin \Eloquent
 */
class SalesOrder_LocationData extends WebModel
{
	protected $table = "SalesOrder_LocationData";

    use SoftDeletes;
    use UuidForKey;

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');
    }

    public function salesOrderLocationDecoded() {
        return $this->hasOne(SalesOrder_LocationDecoded::class, 'salesorderlocationdata_id', 'id');
    }

}
