<?php

namespace Marcolin\Exports;


use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;

class ArrayExport implements WithTitle, WithHeadings, ShouldAutoSize, FromArray {
    private $array;
    private $title;
    private $headings;
    public function __construct($array, $title = 'Report', $headings = [])
    {
        $this->array = $array;
        $this->title = $title;
        $this->headings = count($headings) === 0 && count($array) > 0? array_keys(array_first($array)) : $headings;
    }

    /**
     * @return array
     */
    public function array(): array
    {
        return $this->array;
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return $this->headings;
    }
}
