<html>
<head>
    <title>Marcolin Return Authorization (Code {{ $order->orderNumber or ''}})</title>
</head>
<body style="word-wrap: break-word; -webkit-nbsp-mode: space; -webkit-line-break: after-white-space;">
<table width="600px" cellpadding="5" cellspacing="0" border="0"
       style="font: 12px verdana; color: #000000; border-collapse: collapse;">
    <tr>
        <td colspan="8" align="left">
            <img width="166" vspace="0" hspace="0" border="0" alt="Marcolin Vision"
                 style="border: 0px;display: block;width: 100%;max-width: 250px;"
                 src="{!! $message->embed(public_path('images/logo_marcolin.jpg')) !!}">
        </td>
    </tr>
    <tr>
        <td colspan="8" align="left">
            Marcolin U.S.A. Eyewear Corp.<br>
            3140 Route 22 West<br>
            Somerville, NJ 08876<br>
            Tel: (800) 345 8482<br>
            infousa@marcolin.com<br>
        </td>
    </tr>
    <tr>
        <td colspan="8" align="right">
            @include('marcolin::partials.addressBlock', ['customer' => $order->customer])
            @if($order->customer->email != '')
                <br>Email: {{ $order->customer->email }}
            @endif
            @if($order->customer->fax != '')
                <br>Fax: {{ $order->customer->formatted_fax }}
            @endif
            @if($order->customer->telephone2 != '')
                <br>Tel: {{ $order->customer->formatted_telephone2 }}
            @endif
        </td>
    </tr>
    @if($order->salesGroup != null && $order->salesGroup != '')
    <tr>
        <td colspan="8" align="right">
            <b>Rep:</b> {{ $order->salesGroup or '' }}
        </td>
    </tr>
    @endif
    <tr>
        <td colspan="8" align="right">
            <b>Return authorization code:</b> {{ $order->orderNumber or '' }}
        </td>
    </tr>
    <tr>
        <td colspan="8" align="left">
            <b>Returned articles</b>
        </td>
    </tr>
    <tr style="border: 1px solid black; background-color: lightgray;">
        <td>Model</td>
        <td>Size</td>
        <td>Color</td>
        <td align="center">Quantity</td>
        <td colspan="3">Description</td>
        <td>Type</td>
    </tr>
    @foreach($order->salesOrderItems()->orderBy('style')->orderBy('color')->orderBy('size')->get() as $salesOrderItem)
        <tr style="border: 1px solid black;">
            <td>{{ $salesOrderItem->unit->style }}</td>
            <td>{{ $salesOrderItem->unit->size }}</td>
            <td>{{ $salesOrderItem->unit->color }}</td>
            <td align="center">{{ $salesOrderItem->quantity }}</td>
            <td colspan="3">
                {{ $salesOrderItem->unit->colorDescription }}
            </td>
            <td>Return</td>
        </tr>
    @endforeach
    <tr>
        <td colspan="3" align="right">
            <b>Total:</b>
        </td>
        <td align="center">
            {{ $order->total_quantity }}
        </td>
        <td colspan="4">
        </td>
    </tr>
    <tr>
        <td>
        </td>
    </tr>
    <tr>
        <td colspan="8" align="left">
            <b>Instructions:</b><br>
            1. Each frame must be returned in the original case, or in individual bags.<br>
            2. Frames must be packaged in sturdy shipping carton and secure with packing tape<br>
            3. Each carton must be the appropriate size for the quantity of frames enclosed with filler material to reduce the amount of shifting during shipment.<br>
            4. Cartons must be marked in sequence. (box 1 of 5,2 of 5, etc)<br>
            5. The Order Number (RA#) must be written on the outside of the container on the upper left corner.<br>
            6. Paperwork identifying the contents of the package must be placed inside the carton.<br>
            7. Enclose a copy of this Authorization with your return.<br>
            <br>
            <b>Ship packages to</b><br>
            @if ($order->customer->salesOffice === 'UN03')
            Marcolin Returns<br>
            1022 Champlain Ave<br>
            Burlington, ON<br>
            L7L 0C2<br>
            @else
            Marcolin USA Eyewear Corp.<br>
            3140 Route 22 West<br>
            Somerville, 08876, NJ<br>
            @endif
            <br>
            <b>***This Exchange Authorization expires in 60 days from date of origination.***</b><br>
            <br>
            <i>Please do not reply to this email address.  This email inbox is unmonitored.  For assistance, please contact your sales representative</i>
        </td>
    </tr>
</table>
</body>
</html>