<?php

namespace Hilco\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Hilco\Models\WebUser
 *
 * @property integer $id
 * @property string $email
 * @property string $password
 * @property string $name
 * @property integer $customer_id
 * @property string $remember_token
 * @property string $authy_status
 * @property string $authy_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property string $last_login
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereEmail($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser wherePassword($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereRememberToken($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereLastLogin($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereAuthyStatus($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebUser whereAuthyId($value)
 * @method static WebUser firstOrNew($attributes)
 * @mixin \Eloquent
 * @property-read \Hilco\Models\Customer $customer
 */
class WebUser extends WebModel implements AuthenticatableContract, AuthorizableContract, CanResetPasswordContract {
	use Authenticatable, Authorizable, CanResetPassword;

	protected $table = "WebUsers";
	protected $fillable = ['email', 'password', 'username', 'name', 'customer_id', 'is_enabled', 'webRoles', 'webRoleIds', 'webPermissionIds', 'needs_password_reset', 'default_websilo_id'];
	protected $hidden = ['password', 'remember_token'];

	public function customer() {
		return $this->belongsTo(Customer::class);
	}

    public function webAuthEvents() {
	    return $this->hasMany(WebAuthEvent::class, 'email', 'email');
    }

	public function webRoles()
    {
        return $this->belongsToMany(WebRole::class, 'WebRole_WebUser', 'webuser_id', 'webrole_id');
    }

    public function webPermissions() {
        return $this->belongsToMany(WebPermission::class, 'WebPermission_WebUser', 'webuser_id', 'webpermission_id');
    }

    public function defaultWebSilo() {
        return $this->belongsTo(WebSilo::class, 'default_websilo_id', 'id');
    }

    public function favoriteStyles() {
        return $this->belongsToMany(WebStyle::class, 'WebStyle_WebUser', 'webuser_id', 'webstyle_id');
    }

	public function can($permissionSlug, $arguments = []) {
        return $this->checkPermission($permissionSlug);
    }

    public function hasRole($roleSlug) {
        return $this->webRoles->where('slug', $roleSlug)->count() > 0;
    }

    public function hasDirectPermission($permissions) {
        if ($permissions instanceof WebPermission) $permissions = $permissions->slug;
        if (!is_array($permissions)) $permissions = [$permissions];
        return $this->webPermissions->whereIn('slug', $permissions)->count() > 0;
    }

    public function hasRolePermission($permissions) {
        if ($permissions instanceof WebPermission) $permissions = $permissions->slug;
        if (!is_array($permissions)) $permissions = [$permissions];
        return $this->webRoles->pluck('webPermissions')->flatten()->whereIn('slug', $permissions)->count() > 0;
    }

	protected function checkPermission($permissionSlug) {
        return $this->effective_permissions->where('slug', $permissionSlug)->count() > 0;
    }

	public function getEffectivePermissionsAttribute() {
	    $rolePemissions = $this->webRoles->pluck('webPermissions')->flatten()->keyBy('id');
        $userPermissions = $this->webPermissions->keyBy('id');
        return $rolePemissions->merge($userPermissions);
	}

    public function hasActiveCustomer() {
        return !is_null($this->active_customer);
    }

    public function setWebRolesAttribute($webRoleIds) {
        $this->save();
        $this->webRoles()->sync($webRoleIds);
    }

    public function setWebRoleIdsAttribute($ids) {
        return $this->setWebRolesAttribute($ids);
    }

    public function getWebRoleIdsAttribute() {
        return $this->webRoles->pluck('id')->toArray();
    }

    public function setWebPermissionIdsAttribute($ids) {
        $this->save();
        $this->webPermissions()->sync($ids);
    }

    public static function aliasAs($customerId = false) {
        if ($customerId) {
            session()->put('alias.customerId', $customerId);
            session()->forget('activeCustomer');
            self::activeCustomer();
            session()->forget('activePriceList');
            self::activePriceList();
            session()->forget('activeCurrency');
            self::activeCurrency();
        } else {
            session()->forget('alias.customerId');
            session()->forget('activePriceList');
            session()->forget('activeCurrency');
            session()->forget('activeCustomer');
        }
    }

    public static function isAliased() {
        return (session()->get('alias.customerId', false));
    }

    public function getActiveCustomerAttribute() {
        return self::activeCustomer();
//        if (session()->get('alias.customerId', false)) {
//            $customer = Customer::with('segments', 'discounts')->find(session()->get('alias.customerId'));
//        } else {
//            $customer = $this->customer;
//        }
//        return $customer;
    }

    public static function activeCustomer() {
//        $activeCustomer = session()->get('activeCustomer', false);
        $activeCustomer = Customer::first();
        if (!$activeCustomer) {
            if (session()->get('alias.customerId', false)) {
                $activeCustomer = Customer::with('segments.address.plant', 'discounts')->find(session()->get('alias.customerId'));
            } else {
                $user = auth()->user();
                if ($user) $activeCustomer = $user->customer;
                else $activeCustomer = false;
            }
            session()->set('activeCustomer', $activeCustomer);
        }
        return $activeCustomer;
    }

    public function getCurrencyAttribute() {
        return $this->activeCustomer ? $this->activeCustomer->currency : 'USD';
    }

    public static function activeCurrency() {
        $activeCurrency = session()->get('activeCurrency', false);
        if (!$activeCurrency) {
            $user = auth()->user();
            if ($user) $activeCurrency = $user->currency;
            else $activeCurrency = 'USD';
            session()->set('activeCurrency', $activeCurrency);
        }
        return $activeCurrency;
    }

    public function getDefaultPriceListAttribute() {
        $list = 'Catalog';
        $activeCustomer = $this->activeCustomer;
        if (is_null($activeCustomer)) return $list;
        $activeSegment = $activeCustomer->activeSegment;
        if (is_null($activeSegment)) return $list;
        return $activeSegment->def_price_list;
    }

    public static function activePriceList() {
        $activePriceList = session()->get('activePriceList', false);
        if (!$activePriceList) {
            $user = auth()->user();
            if ($user) $activePriceList = $user->default_price_list;
            else $activePriceList = 'Catalog';
            session()->set('activePriceList', $activePriceList);
        }
        return $activePriceList;
    }

    public static function activeShippingAddress($activeShippingAddress = false) {
        if ($activeShippingAddress) {
            session()->set('activeShippingAddress', $activeShippingAddress);
            return $activeShippingAddress;
        }

        $activeShippingAddress = session()->get('activeShippingAddress', false);
        if (!$activeShippingAddress) {
            $customer = self::activeCustomer();
            if ($customer) $activeShippingAddress = $customer->default_shipping_address;
            session()->set('activeShippingAddress', $activeShippingAddress);
        }
        return $activeShippingAddress;
    }

    public static function activeCountry() {
        $activeCustomer = self::activeCustomer();
        if (!$activeCustomer) return null;
        $defaultAddress = $activeCustomer->default_shipping_address;
        if (!$defaultAddress) return null;
        return $defaultAddress->country;
    }

    public function getCountryAttribute() {
        $defaultAddress = $this->customer->default_shipping_address;
        if (!$defaultAddress) return null;
        return $defaultAddress->country;
    }


    public function getTaxes($shippingAddress) {
        $taxes = [];
        $customer = $this->activeCustomer;
        if (is_null($customer)) return 0;

        $segment = $customer->activeSegment;
        if (is_null($segment)) return 0;

        $additionalTaxCustomerSegments = $segment->additionalTaxCustomerSegment;
        if ($additionalTaxCustomerSegments) {
            foreach ($additionalTaxCustomerSegments as $additionalTaxCustomerSegment) {
                $additionalTaxes = $additionalTaxCustomerSegment->additionalTax;
                if ($additionalTaxes) {
                    foreach ($additionalTaxes as $additionalTax) {
                        $taxes[] = $additionalTax->tax_percentage;
                    }
                }
            }
        }

        $tax = StateTax::inEffect()->whereState($shippingAddress->state)->first();
        if ($tax) {
            $taxes[] = $tax->tax_percentage;
        }

        return $taxes;
    }

    use RevisionableTrait;
}
