<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Hilco\Models\Brand
 *
 * @property integer $id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Brand whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Brand whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Brand whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Brand whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Brand whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Brand extends Model
{
	protected $table = "Brands";

	function style() {
		return $this->belongsToMany(Style::class);
    }

    public function webBrand() {
        return $this->belongsTo(WebBrand::class);
    }

    public function getNameAttribute() {
        return $this->brandName;
    }
}
