<?php

namespace Marcolin\Models;

use DB;


class AutocatCatalogItem extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogItems";

    protected static $morphMap = [
        'webStyle' => WebStyle::class,
    ];

    public static function getMorphMap()
    {
        return self::$morphMap;
    }

    public static function getItemClass($morphMapKey)
    {
        return array_get(self::$morphMap, $morphMapKey);
    }

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatCatalog_id', 'id');
    }

    public function autocatCatalogItemModifiers()
    {
        return $this->hasMany(AutocatCatalogItemModifier::class, 'autocatCatalogItem_id', 'id');
    }

    public function item()
    {
        return $this->morphTo();
    }
}
