<?php
/**
 * Created by PhpStorm.
 * User: Dave
 * Date: 4/15/2015
 * Time: 12:43 AM
 */

namespace Marcolin\Models\Traits;


trait UploadableTrait {

    public function uploads() {
       return $this->morphMany('Marcolin\Models\Upload','uploadable');
    }

    public function hasUploadType($type) {
        return !$this->uploads()->where('type','=',$type)->get()->isEmpty();
    }

    public function uploadsByType($type) {
        return $this->uploads()->where('type','=',$type)->get();
    }

    /** @return \Marcolin\Models\Upload */
    public function firstOfUploadType($type) {
        return $this->uploads()->where('type','=',$type)->first();
    }

    public function thumbs() {
        return $this->uploads()->whereType('thumb');
    }

    public function getThumbAttribute() {
        return $this->thumbs()->first();
    }

    public function setThumbAttribute(Upload $thumb) {
        $thumb->type = 'thumb';
        $this->uploads()->save($thumb);
    }
}