<?php

namespace Marcolin\Models;

use Illuminate\Support\Facades\DB;


class AutocatCatalog extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogs";

    public function autocatCatalogItems()
    {
        return $this->hasMany(AutocatCatalogItem::class, 'autocatCatalog_id', 'id');
    }

    public function autocatCatalogModifiers()
    {
        return $this->hasMany(AutocatCatalogModifier::class, 'autocatCatalog_id', 'id');
    }

    public function autocatLayout()
    {
        return $this->belongsTo(AutocatLayout::class, 'autocatLayout_id', 'id');
    }

    public function webUser()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function getCatalogIdStringAttribute() {
        return DB::selectOne('SELECT UuidFromBin(id) as id FROM AutocatCatalogs WHERE id = ?', [$this->id])->id;
    }

    public function getNameCleanAttribute() {
        $name = $this->name;

        preg_replace("/[^A-Za-z0-9]+/", '_', $name);

        return "$name.pdf";
    }

    public function getFilenameAttribute() {
        return "$this->idString.pdf";
    }

    public function makeCopy($newCatalogName) {
        $autocatCatalog = new AutocatCatalog();
        $autocatCatalog->webUser()->associate($this->webUser);
        $autocatCatalog->autocatLayout()->associate($this->autocatLayout);
        $autocatCatalog->name = $newCatalogName;
        $autocatCatalog->status = 'STARTED';
        $autocatCatalog->save();

        foreach($this->autocatCatalogItems as $autocatItem) {
            $item = new AutocatCatalogItem();
            $item->autocatCatalog_id = $autocatCatalog->id;
            $item->item_id = $autocatItem->item_id;
            $item->item_type = $autocatItem->item_type;
            $item->order = $autocatItem->order;
            $item->save();
        }

        foreach($this->autocatCatalogModifiers as $autocatModifier) {
            $modifier = new AutocatCatalogModifier();
            $modifier->modifier_type = $autocatModifier->modifier_type;
            $modifier->modifier_value = $autocatModifier->modifier_value;
            $modifier->autocatCatalog_id = $autocatCatalog->id;
            $modifier->save();
        }
    }
}
