<?php
namespace Marcolin\Models;

use AlgoliaSearch\Laravel\AlgoliaEloquentTrait;
use Illuminate\Database\Eloquent\Model;
use Marcolin\Models\Traits\UploadableTrait;

class Tag extends WebModel {

    use UploadableTrait;

    protected $table = 'CMSTags';
    protected $fillable = ['name', 'group'];

    public function content() {
        return $this->morphedByMany('Marcolin\Models\Content', 'taggable', 'CMSTaggables', 'cmsTag_id', 'cmsTaggable_id');
    }

    public function getThumbPath() {
        $thumb = $this->firstOfUploadType('thumb');
        if(isset($thumb)) {
            return $this->firstOfUploadType('thumb')->getContentsPath();
        } else {
            return $thumb;
        }
    }

    public function scopeCollections($q) {
        return $q->whereGroup('collection')->with('thumbs');
    }

    public static function boot() {
        parent::boot();
        static::saving(function($model) { return $model->_saving(); });
    }

    public function _saving() {
//        Log::info('creating slug automatically', $this->toArray());
        $this->slug = str_slug('slg-' . $this->group . ' ' . $this->name);
    }

//    use AlgoliaEloquentTrait;
//
//    public static $perEnvironment = true;
//
//    public $algoliaSettings = [
//        'searchableAttributes' => [
//            'name',
//            'group',
//        ],
//        'attributesForFaceting' => [
//            'group',
//        ]
//    ];
//
//    public function _reindex($safe = true, $setSettings = true, $mergeOldSettings = false, \Closure $onInsert = null)
//    {
//        /** @var \AlgoliaSearch\Laravel\ModelHelper $modelHelper */
//        $modelHelper = App::make('\AlgoliaSearch\Laravel\ModelHelper');
//
//        $indices = $modelHelper->getIndices($this);
//        $indicesTmp = $safe ? $modelHelper->getIndicesTmp($this) : $indices;
//
//        if ($setSettings === true) {
//            $setToTmpIndices = ($safe === true);
//            $this->_setSettings($setToTmpIndices, $mergeOldSettings);
//        }
//
//        static::chunk(500, function ($models) use ($indicesTmp, $modelHelper, $onInsert) {
//                /** @var \AlgoliaSearch\Index $index */
//                foreach ($indicesTmp as $index) {
//                    $records = [];
//                    $recordsAsEntity = [];
//
//                    foreach ($models as $model) {
//                        if ($modelHelper->indexOnly($model, $index->indexName)) {
//                            $records[] = $model->getAlgoliaRecordDefault($index->indexName);
//
////                            dd($records);
//
//                            if ($onInsert && is_callable($onInsert)) {
//                                $recordsAsEntity[] = $model;
//                            }
//                        }
//                    }
//
//                    $index->addObjects($records);
//
//                    if ($onInsert && is_callable($onInsert)) {
//                        call_user_func_array($onInsert, [$recordsAsEntity]);
//                    }
//                }
//
//            });
//
//        if ($safe) {
//            for ($i = 0; $i < count($indices); $i++) {
//                $modelHelper->algolia->moveIndex($indicesTmp[$i]->indexName, $indices[$i]->indexName);
//            }
//
//            $this->_setSettings(false); // To a setSettings to set the slave on the master
//        }
//    }
//
//    public function indexOnly()
//    {
//        return true;
//    }
//
//    public function getAlgoliaRecord()
//    {
//        $record = array_only($this->toArray(), [
//            'id',
//        ]);
//
//        $record['name'] = $this->name;
//        $record['group'] = $this->key;
//
//        $unwanted_keys = ['date_created', 'date_modified', 'date_uploaded', 'deleted_at', 'commit_sequence'];
//        $this->recursive_unset($record, $unwanted_keys);
//
//        return $record;
//    }
//
//    function recursive_unset(&$array, $unwanted_keys)
//    {
//        foreach ($unwanted_keys as $unwanted_key) {
//            unset($array[$unwanted_key]);
//        }
//        foreach ($array as &$value) {
//            if (is_array($value)) {
//                $this->recursive_unset($value, $unwanted_keys);
//            }
//        }
//    }
//
//    protected $indexSettings = [
//        'analysis' => [
//            'char_filter' => [
//                'replace' => [
//                    'type' => 'mapping',
//                    'mappings' => [
//                        '&=> and '
//                    ],
//                ],
//            ],
//            'filter' => [
//                'word_delimiter' => [
//                    'type' => 'word_delimiter',
//                    'split_on_numerics' => false,
//                    'split_on_case_change' => false,
//                    'generate_word_parts' => true,
//                    'generate_number_parts' => true,
//                    'catenate_all' => true,
//                    'preserve_original' => true,
//                    'catenate_numbers' => true,
//                ]
//            ],
//            'analyzer' => [
//                'default' => [
//                    'type' => 'custom',
//                    'char_filter' => [
//                        'html_strip',
//                        'replace',
//                    ],
//                    'tokenizer' => 'whitespace',
//                    'filter' => [
//                        'lowercase',
//                        'word_delimiter',
//                    ],
//                ],
//            ],
//        ],
//    ];
//
//    protected $mappingProperties = [
//        'title' => [
//            'type' => 'string',
//            'analyzer' => 'standard'
//        ]
//    ];
}
