<?php

namespace Marcolin\Models;

use DB;


class CustomerCodeHierarchy extends WebModel {
    protected $table = "CustomerCodeHierarchies";
    protected $fillable = ['customerCodeHierarchy', 'customerCodeHierarchyName', 'commit_sequence'];

    use HasCommitSequence;

    public function customers() {
        return $this->hasMany(Customer::class, 'customerCodeHierarchy_id', 'id');
    }

    public function webSilo() {
        return $this
            ->belongsToMany(WebSilo::class, 'WebSilo_BuyingGroup', 'customerCodeHierarchy_id', 'websilo_id')
            ;
    }
}
