<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;

class WebCustomerSalesSummaryValue extends Model
{
    protected $table = "WebCustomerSalesSummaryValues";
    protected $fillable = ['webcustomersalessummary_id', 'productcategorygroup_id', 'total'];
    public $timestamps = false;

    public function summary()
    {
        return $this->belongsTo(WebCustomerSalesSummary::class, 'webcustomersalessummary_id', 'id');
    }

    public function productCategoryGroup()
    {
        return $this->belongsTo(ProductCategoryGroup::class, 'productcategorygroup_id', 'id');
    }
}
