<?php

namespace Marcolin\Models;

use Illuminate\Support\Facades\DB;


class AutocatCatalog extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogs";

    public function autocatCatalogItems()
    {
        return $this->hasMany(AutocatCatalogItem::class, 'autocatCatalog_id', 'id');
    }

    public function autocatCatalogStyles()
    {
        return $this->hasMany(AutocatCatalogStyle::class, 'autocatcatalog_id', 'id');
    }

    public function autocatCatalogSearchFacets()
    {
        return $this->hasMany(AutocatCatalogSearchFacet::class, 'autocatcatalog_id', 'id');
    }

    public function autocatCatalogModifiers()
    {
        return $this->hasMany(AutocatCatalogModifier::class, 'autocatCatalog_id', 'id');
    }

    public function autocatLayout()
    {
        return $this->belongsTo(AutocatLayout::class, 'autocatLayout_id', 'id');
    }

    public function webUser()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function getCatalogIdStringAttribute() {
        return DB::selectOne('SELECT UuidFromBin(id) as id FROM AutocatCatalogs WHERE id = ?', [$this->id])->id;
    }

    public function getNameCleanAttribute() {
        $name = $this->name;
        $name = preg_replace("/[^A-Za-z0-9]+/", '_', $name);
        return "$name.pdf";
    }

    public function getFilenameAttribute() {
        return "$this->idString.pdf";
    }

    public function makeCopy($newCatalogName, $newCatalogTitle = null) {
        $autocatCatalog = new AutocatCatalog();
        $autocatCatalog->webUser()->associate($this->webUser);
        $autocatCatalog->autocatLayout()->associate($this->autocatLayout);
        $autocatCatalog->name = $newCatalogName;
        $autocatCatalog->status = 'STARTED';
        $autocatCatalog->save();

        foreach($this->autocatCatalogItems as $autocatItem) {
            $item = new AutocatCatalogItem();
            $item->autocatCatalog_id = $autocatCatalog->id;
            $item->item_id = $autocatItem->item_id;
            $item->item_type = $autocatItem->item_type;
            $item->order = $autocatItem->order;
            $item->save();
        }

        foreach($this->autocatCatalogStyles as $autocatStyle) {
            $new_autocat_style = new AutocatCatalogStyle();
            $new_autocat_style->autocatcatalog_id = $autocatCatalog->id;
            $new_autocat_style->style_id = $autocatStyle->style_id;
            $new_autocat_style->default_status = $autocatStyle->default_status;
            $new_autocat_style->override_status = $autocatStyle->override_status;
            $new_autocat_style->order = $autocatStyle->order;
            $new_autocat_style->save();

            foreach($autocatStyle->autocatCatalogUnits as $autocatCatalogUnit) {
                $new_autocat_unit = new AutocatCatalogUnit();
                $new_autocat_unit->autocatcatalog_id = $autocatCatalog->id;
                $new_autocat_unit->autocatcatalogstyle_id = $new_autocat_style->id;
                $new_autocat_unit->unit_id = $autocatCatalogUnit->unit_id;
                $new_autocat_unit->default_status = $autocatCatalogUnit->default_status;
                $new_autocat_unit->override_status = $autocatCatalogUnit->override_status;
                $new_autocat_unit->order = $autocatCatalogUnit->order;
                $new_autocat_unit->save();
            }

            foreach($autocatStyle->autocatCatalogStyleModifiers as $autocatCatalogStyleModifier) {
                $new_autocat_style_modifiers = new AutocatCatalogStyleModifier();
                $new_autocat_style_modifiers->autocatcatalogstyle_id = $new_autocat_style->id;
                $new_autocat_style_modifiers->modifier_type = $autocatCatalogStyleModifier->modifier_type;
                $new_autocat_style_modifiers->modifier_value = $autocatCatalogStyleModifier->modifier_value;
                $new_autocat_style_modifiers->save();
            }
        }
        
        if ($newCatalogTitle) {
            $modifier = new AutocatCatalogModifier();
            $modifier->modifier_type = 'title';
            $modifier->modifier_value = $newCatalogTitle;
            $modifier->autocatCatalog_id = $autocatCatalog->id;
            $modifier->save();
        }
    }
}
