<?php

namespace Marcolin\Models;
use Marcolin\SoftDeletes;

/**
 * Class Promotion_SalesOrder
 * @package Marcolin\Models
 */
class Promotion_SalesOrder extends UuidModel {
    protected $table = 'Promotion_SalesOrder';
    
    use SoftDeletes;

    /**
     * Get the relationship to owning-PromotionCodeTrigger
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');

    }
}