<?php

namespace Marcolin\Models;

/**
 * Marcolin\Models\WebFeedbackResponse
 *
 * @property mixed $id
 * @property string $webuser_id
 * @property string $feedback_type_id
 * @property string $feedback_subject_id
 * @property string $details
 * @property string $deleted_at
 * @property string $date_created
 * @property string $date_modified
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereFeedbackTypeId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereFeedbackSubjectId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\WebFeedbackResponse whereDeletedAt($value)
 * @mixin \Eloquent
 */
class WebFeedbackResponse extends WebModel
{
    protected $table = 'WebFeedbackResponses';

    public function feedbackSubject()
    {
        $this->belongsTo(FeedbackSubject::class, 'feedback_subject_id');
    }

    public function feedbackType()
    {
        $this->belongsTo(FeedbackType::class, 'feedback_type_id');
    }

    public function webUser()
    {
        $this->belongsTo(WebUser::class, 'webuser_id');
    }
}
