<?php

namespace Marcolin\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


/**
 * Marcolin\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereFobCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereFobDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Style extends Model
{
	protected $table = "Styles";

    function brand() {
        return $this->belongsTo(Brand::class);
    }

    function productDescription() {
        return $this->hasMany(ProductDescription::class, "style", "style");
    }

    function units() {
        return $this->hasMany(Unit::class);
    }

    public function productShape() {
        return $this->belongsTo(ProductShape::class, 'productShape_id', 'id');
    }

    public function productFitting() {
        return $this->belongsTo(ProductFitting::class, 'productFitting_id', 'id');
    }

    public function productRimType() {
        return $this->belongsTo(ProductRimType::class, 'productRimType_id', 'id');
    }

    public function productGender() {
        return $this->belongsTo(ProductGender::class, 'productGender_id', 'id');
    }

    public function productType() {
        return $this->belongsTo(ProductType::class, 'productType_id', 'id');
    }

    public function orderHistories() {
        return $this->hasMany(SalesData::class, 'style', 'style');
    }

    public function webStyle() {
        return $this->hasOne(WebStyle::class);
    }

    public function getUnitsByColorAttribute() {
        return $this
            ->units
            ->groupBy('color')
            ->map(function ($item, $key) {
                return $item->first();
            })->values();
    }

    public function getOrderableAttribute($customer = false) {
        return $this->brand->orderable;
    }

    public function getDetailAttribute() {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->productDesc;
            if (strlen($styleName) > 0) {
                return $styleName;
            }
        }
        return '';
    }

    public function getNameAttribute() {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->styleName;
            if (strlen($styleName) > 0) {
                return title_case($productDescription->first()->styleName);
            }
        }
        return $this->style;
    }

    public function getDisplayNameAttribute() {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->styleName;
            if (strlen($styleName) > 0) {
                return $this->style.' '.title_case($productDescription->first()->styleName);
            }
        }
        return $this->style;
    }

    public function getProductTypeDescriptionAttribute() {
        $productType = $this->productType()->first();
        if (isset($productType)) {
            return $productType->productTypeDescription;
        } else {
            return null;
        }
    }

    public function getProductShapeDescriptionAttribute() {
        $productShape = $this->productShape()->first();
        if (isset($productShape)) {
            return $productShape->shape;
        } else {
            return null;
        }
    }

    public function getProductRimTypeDescriptionAttribute() {
        $productRimType = $this->productRimType()->first();
        if (isset($productRimType)) {
            return $productRimType->rimType;
        } else {
            return null;
        }
    }

    public function getProductFittingDescriptionAttribute() {
        $productFitting = $this->productFitting()->first();
        if (isset($productFitting)) {
            return $productFitting->fitting;
        } else {
            return null;
        }
    }

    public function getProductGenderDescriptionAttribute() {
        $productGender = $this->productGender()->first();
        if (isset($productGender)) {
            return $productGender->genderDescription;
        } else {
            return null;
        }
    }

    public function getCustomerPrice($customer) {
        $unit = $this->units->first();
        if (isset($unit)) {
            return $unit->getCustomerPrice($customer);
        } else {
            return null;
        }
    }

    public function scopeWebVisible($query) {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisible();
            })
        ;
        return $query;
    }
}
