<?php

namespace Marcolin\Models;


class WebSilo_BuyingGroup extends WebModel {
    protected $table = 'WebSilo_BuyingGroup';
    protected $fillable = ['websilo_id', 'customerCodeHierarchy_id', 'commit_sequence'];

    use HasCommitSEquence;

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function customerCodeHierarchy() {
        return $this->belongsTo(CustomerCodeHierarchy::class, 'customerCodeHierarchy_id', 'id');
    }

    public function scopeWebSiloBuyingGroup($query, $websilo_id, $customerCodeHierarchy_id) {
        return $query
            ->where('websilo_id', $websilo_id)
            ->where('customerCodeHierarchy_id', $customerCodeHierarchy_id)
        ;
    }

}