<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Marcolin\Listeners;

use Illuminate\Support\Facades\Mail;
use Marcolin\Events\ReturnWasPlaced;

/**
 * Sends an order confirmation email to the customer.
 *
 * Class EmailOrderConfirmation
 * @package Marcolin\Listeners
 */
class EmailReturnAuth
{
    public function construct()
    {

    }

    public function handle(ReturnWasPlaced $event)
    {
        $repEmailArray = [];
        $salesRep = $event->order->salesRep;
        if ($salesRep != null && ($event->repNumber === false || $event->repNumber == $salesRep->salesGroup)) {
            $email = $salesRep->salesGroupEmail;
            $repEmailArray[strtoupper($email)] = $email;
        }

        // Gets the list of To addresses (customers)
        $toEmailList = [];
        if (config('app.debug') === false && $event->order->total_quantity < 25 && !$event->notCustomer) {
            if (strlen($event->order->customer->email)) $toEmailList[strtoupper($event->order->customer->email)] = $event->order->customer->email;
                if (!$event->order->isGuestAccountOrder()) {
                foreach ($event->order->customer->webUsers as $webUser) {
                    if (strlen($webUser->email)) $toEmailList[strtoupper($webUser->email)] = $webUser->email;
                }
            }
        }
        foreach (config('marcolin.emailDestinations.returnAuth.to', []) as $to) {
            if (strlen($to)) $toEmailList[strtoupper($to)] = $to;
        }

        // Gets the list of CC addresses (reps)
        $ccEmailList = [];
        if (config('app.debug') === false) {
            $ccEmailList = $repEmailArray;
        }

        // Gets the list of BCC addresses (us and customer servicer mostly)
        $bccEmailList = [];
        foreach (config('marcolin.emailDestinations.returnAuth.bcc', []) as $bcc) {
            if (strlen($bcc)) $bccEmailList[strtoupper($bcc)] = $bcc;
        }

        if (count($toEmailList) > 0 || count($bccEmailList) > 0) {
            Mail::send('marcolin::emails.orders.returnAuth', ['order' => $event->order, 'url' => config('marcolin.b2b.url')], function ($email) use ($event, $toEmailList, $ccEmailList, $bccEmailList) {
                foreach ($toEmailList as $to) {
                    $email->to($to);
                }

                foreach ($ccEmailList as $cc) {
                    $email->cc($cc);
                }

                foreach ($bccEmailList as $bcc) {
                    $email->bcc($bcc);
                }

                $email->from(config('mail.from_return.address'), config('mail.from_return.name'));

                if (config('mail.replyto_return.address') != '') {
                    $email->replyTo(config('mail.replyto_return.address'), config('mail.replyto_return.name'));
                }
                
                $email->subject(trans('marcolin::email.returnAuthSubject', ['repNumber' => $event->order->salesGroup, 'orderNumber' => $event->order->orderNumber, 'customerNumber' => $event->order->customer->customerCode]));
            });
        }
    }
}