<?php

namespace Marcolin\Models;

use DB;


class SalesRep extends WebModel
{
    protected $table = "SalesReps";

    public function brands()
    {
        return $this->belongsToMany(Brand::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'brand_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->distinct();
    }

    public function harleySubReps() {
        // I know this foreign key seems backwards, but it isn't, we want all the HarleySubReps where this rep is the parent rep
        return $this->hasMany(HarleyRep::class, 'parent_salesrep_id', 'id');
    }

    public function harleyParentRep(){
        // I know this foreign key seems backwards, but it isn't, we want all  HarleyParentRep where this rep is the sub rep
        return $this->hasOne(HarleyRep::class, 'salesrep_id', 'id');
    }


    public function brandNames(){
        return $this->brands->pluck('brandName')->all();
    }

    public function salesDistrict()
    {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->withPivot('brand_id');
    }

    public function salesDistrictTrashed()
    {
        return $this->belongsToMany(SalesDistrict::class, 'SalesRep_Customer_Brand', 'salesrep_id', 'salesDistrict_id')
            ->wherePivot('deleted_at', '=', '0000-00-00 00:00:00')
            ->withPivot('brand_id')
            ->withTrashed();
    }
    
}
