<?php

namespace Marcolin\Models;

use DB;


class SalesData extends WebModel
{
    protected $table = "SalesData";

    public function customer()
    {
        return $this->hasOne(Customer::class, 'customer_id', 'id');
    }

    public function scopeForCustomer($query, Customer $customer)
    {
        return $query->where('customer_id', $customer->id);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }
}
