@if($edit)
    <div class="mceNonEditable component-container" data-component-key="promoBanners">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Web Promotions</h4>
        <p>Displays promotion banner(s) across the entire width of the page that cycle.</p>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoBanners', {
            menuText: 'Web Promotions',
            bladeTemplate: 'marcolin::components.promoBanners',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div id="promotions-carousel" class="owl-carousel owl-theme">
        @foreach(b2b()->eligiblePromotions() as $promotion)
            @if ($promotion->is_visible && strlen($promotion->homepage_banner_text))
                <div class="alert alert-info text-center" style="font-size: 14pt;">
                    @if (strlen($promotion->homepage_banner_link))
                        <a href="{!! $promotion->homepage_banner_link !!}">
                            <strong>{!! $promotion->homepage_banner_text !!}</strong>
                        </a>
                    @else
                        <strong>{!! $promotion->homepage_banner_text !!}</strong>
                    @endif
                </div>
            @endif
        @endforeach
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#promotions-carousel').owlCarousel({
                center: true,
                items: 1,
                @if(count(b2b()->eligiblePromotions()) > 1) loop: true, @endif
                autoplay: true,
                autoplayTimeout: 5000,
                autoplayHoverPause: true,
                dots: true,
            });
        });
    </script>
@endif