<?php
/**
 * Created by PhpStorm.
 * User: Randy
 * Date: 12/20/2017
 * Time: 9:38 AM
 */

namespace Marcolin\Models;

use Illuminate\Support\Facades\Config;
use Marcolin\Models\Traits\UploadableTrait;
use Marcolin\Models\Traits\RestrictableTrait;


class Announcement extends WebModel
{
    use UploadableTrait;
    use RestrictableTrait;
    protected $table = 'CMSAnnouncements';
    protected $fillable = ['title', 'message', 'expiration_date', 'key', 'featured'];

    public function publisher()
    {
        return $this->belongsTo('Marcolin\Models\WebUser', 'publisher_webUser_id');
    }

    public function tags() {
        return $this->morphToMany('Marcolin\Models\Tag', 'taggable', 'CMSTaggables', 'cmsTaggable_id', 'cmsTag_id');
    }

    public function restrictions() {
        return $this->morphToMany('Marcolin\Models\WebRole', 'restrictable', 'CMSRestrictables', 'cmsRestrictable_id', 'webRole_id');
    }

    public function hasRestriction($roleID) {
        foreach ($this->restrictions as $role) {
            if ($role->id == $roleID) return true;
        }
        return false;
    }

    public function collectionTags() {
        return $this->tags()->whereGroup('collection');
    }

    public function tag($group, $name) {
        $name = trim($name);
        $group = trim($group);
        $tag = Tag::firstOrCreate(['group' => $group, 'name' => $name]);
        $this->tags()->save($tag);
    }

    public function untag($group, $name) {
        $name = trim($name);
        $group = trim($group);
        $tag = Tag::firstOrCreate(['group' => $group, 'name' => $name]);
        $this->tags()->detach($tag); }

    public function untagAll() {
        foreach ($this->tags()->get() as $tag) {
            $this->tags()->detach($tag->id);
        }
        $this->save();
    }


    public function getThumbPath() {
        if($this->hasUploadType('thumb')) {
            return $this->firstOfUploadType('thumb')->getContentsPath();
        } else {
            return Config::get('imagedefaults.content_thumb');
        }
    }

    public function title($length = 60) {
        return strlen($this->title) > $length ? substr($this->title,0,$length)."..." : $this->title;
    }

    public static function scopeFeatured($query) {
        return $query->where('featured','=',1);
    }

}