@if($edit)
    <div class="mceNonEditable component-container" data-component-key="userInfo">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>User Dashboard</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('userInfo', {
            menuText: 'User Dashboard',
            bladeTemplate: 'marcolin::components.userInfo',
            init: function (body) {

            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(canUser('b2b-orders'))
        <div class="row container center-block">
            <div class="col-md-4">
                <div class="panel panel-default" style="height: 300px;">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a href="{{ route('orders.list') }}" class="pull-right">See All</a>
                            Recent Orders
                        </h3>
                    </div>
                    <div class="panel-body">
                        @foreach(b2b()->activeCustomer()->recentOrders(5)->groupBy('orderDate') as $orderDate => $orders)
                            <div class="row">
                                <div class="col-md-12 h4 nomargin">
                                    {{ date('D, M j Y', strtotime($orderDate)) }}
                                </div>
                            </div>
                            @foreach($orders as $order)
                                <div class="row">
                                    <div class="col-md-12">
                                        <div style="padding-left: 10px">
                                            <a href="{{ route('orders.details', [$order->orderNumber]) }}">{{ $order->orderNumber }}</a>
                                            -
                                            @if($order->shipped_quantity > 0)
                                                {{ $order->shipped_quantity }} Shipped
                                            @endif

                                            @if($order->shipped_quantity > 0 && $order->total_quantity > $order->shipped_quantity)
                                                ,
                                            @endif

                                            @if($order->total_quantity - $order->shipped_quantity > 0)
                                                {{ $order->total_quantity - $order->shipped_quantity }} Open
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <hr style="margin: 5px;">
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="panel panel-default" style="height: 300px;">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a href="{{ route('orders.reorder') }}" class="pull-right">See All</a>
                            Reorder Frequently Ordered Items
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div id="favorites-carousel" class="owl-carousel owl-theme">
                            @foreach(b2b()->activeCustomer()->topPurchasedItems() as $webStyle)
                                @if($webStyle->hasPrimaryImage())
                                    @include('partials.style-block', ['webStyle' => $webStyle, 'captionClass' => 'h4', 'containerStyle' => 'display: none;', 'gtagListName' => 'Reorder frequently ordered items', 'gtagIndex' => $loop->index])
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if(\Route::has('orders.orderHistoryDataTable'))
            <script type="text/javascript">
                $(document).ready(function () {
                    var favoriteItemsCarousel = $('#favorites-carousel');
                    favoriteItemsCarousel.on({
                        'initialized.owl.carousel': function () {
                            favoriteItemsCarousel.find('.style-block-item').show();
                        }
                    }).owlCarousel({
                        autoplay: true,
                        autoplayTimeout: 5000,
                        loop: false,
                        responsive: {
                            0: {
                                items: 1,
                            },
                            320: {
                                items: 1
                            },
                            480: {
                                items: 1,
                            },
                            768: {
                                items: 2,
                            },
                            992: {
                                items: 2,
                            },
                            1440: {
                                items: 2,
                            },
                        },
                    });
                });
            </script>
        @endif
    @endif
@endif
