<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Collection;

class WebRole extends WebModel
{

    protected $table = 'WebRoles';
    protected $fillable = ['name', 'slug', 'description', 'is_enabled'];
    protected $with = ['webPermissions'];

    public function webUsers()
    {
        return $this->belongsToMany(WebUser::class, 'WebRole_WebUser');
    }

    public function webPermissions()
    {
        return $this->belongsToMany(WebPermission::class, 'WebPermission_WebRole', 'webrole_id', 'webpermission_id');
    }

    public function cmsPermissions()
    {
        return $this->webPermissions()->where('slug','LIKE','cms-%');
    }

    public static function getDefault()
    {
        return WebRole::where('slug', config('marcolin.defaultWebRoleSlug', 'web-user'))->first();
    }

    public function scopeCmsRoles($query) {
        return $query->whereHas('webPermissions', function ($query) {
            return $query->where('slug', 'cms-login');
        });
    }

    /**
     * @param $user WebUser
     * @return Collection
     */
    public static function weakerCmsRoles($user) {
        $weakerRoles = new Collection();

        foreach (WebRole::cmsRoles()->get() as $cmsRole){
            $stronger = false;
            $weaker = false;
            foreach ($cmsRole->cmsPermissions()->get() as $rolePermission){
                if (!$user->can($rolePermission->slug)){
                    $stronger = true;
                }
            }
            foreach ($user->cmsPermissions()->all() as $userPermission){
                if ($cmsRole->cmsPermissions()->where('slug',$userPermission->slug)->count() === 0){
                    $weaker = true;
                }
            }
            if (!$stronger && $weaker){
                $weakerRoles->add($cmsRole);
            }
        }
        return $weakerRoles;
    }
}