<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class AutocatCatalogItem extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogItems";

    protected static $morphMap = [
        'webStyle' => WebStyle::class,
    ];

    public static function getMorphMap()
    {
        return self::$morphMap;
    }

    public static function getItemClass($morphMapKey)
    {
        return array_get(self::$morphMap, $morphMapKey);
    }

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatCatalog_id', 'id');
    }

    public function autocatCatalogItemModifiers()
    {
        return $this->hasMany(AutocatCatalogItemModifier::class, 'autocatCatalogItem_id', 'id');
    }

    public function comments()
    {
        return $this->belongsToMany(AutocatCatalogComment::class, 'AutocatCatalogItem_AutocatCatalogComment', 'item_id', 'comment_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function item()
    {
        return $this->morphTo();
    }
}
