<?php

namespace Marcolin\Models;

trait ManyToManyRevisionableTrait
{

    public function createRevisionRecord($key, $old = null, $new = null)
    {
        $revisions = [
            [
                'revisionable_type' => $this->getMorphClass(),
                'revisionable_id' => $this->getKey(),
                'key' => $key,
                'old_value' => $old,
                'new_value' => $new,
                'user_id' => $this->getSystemUserId(),
                'created_at' => new \DateTime(),
                'updated_at' => new \DateTime(),
            ]
        ];
        $revision = new \Venturecraft\Revisionable\Revision;
        \DB::table($revision->getTable())->insert($revisions);
        return true;
    }
}

;