@if($edit)
    <div class="mceNonEditable component-container" data-component-key="rebate">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>User Rebates</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('rebate', {
            menuText: 'User Rebates',
            bladeTemplate: 'marcolin::components.rebate',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(isset(b2b()->activeCustomer()->parentCustomerRebateInformation) && b2b()->activeWebSilo()->has_rebates == 1)
        <div class="row container center-block">
            <div class="col-xs-12 text-center">
                <h3>My Marcolin Rebates</h3>
            </div>

            {{--@foreach(b2b()->activeWebSilo()->rebateLevels as $rebateLevel)--}}
                {{--<div class="col-md-{{ floor(12 / count(b2b()->activeWebSilo()->rebateLevels)) }} text-center">--}}
                    {{--<h5 style="color: blue; font-weight: bold;">--}}
                        {{--@if(b2b()->activeCustomer()->parentCustomerRebateInformation->rebateBasedOnQTDVolume == $rebateLevel->rebatePercent)--}}
                            {{--Potential Rebate!--}}
                        {{--@else--}}
                            {{--&nbsp;--}}
                        {{--@endif--}}
                    {{--</h5>--}}
                {{--</div>--}}
            {{--@endforeach--}}
            @foreach(b2b()->activeWebSilo()->rebateLevels()->orderBy('minAmount')->get() as $rebateLevel)
                <div class="col-md-{{ floor(12 /count(b2b()->activeWebSilo()->rebateLevels)) }}">
                    <div class="panel panel-default" style="height: 250px; border: 4px solid {{ '#'.$rebateLevel->color }}; @if(b2b()->activeCustomer()->parentCustomerRebateInformation->rebateBasedOnQTDVolume == $rebateLevel->rebatePercent.".00%") box-shadow: 4px 8px #777777; @else  opacity: 0.5; filter: alpha(opacity = 50); @endif">
                    {{--<div class="panel panel-default" style="height: 250px; border: 4px solid {{ '#'.$rebateLevel->color }};">--}}
                        <div class="panel-body text-center" style="font-size: larger;">
                            <div class="row">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->rebateBasedOnQTDVolume == $rebateLevel->rebatePercent)
                                    <div class="col-md-12 text-center" style="font-weight: bolder; color: blue; margin-bottom: 10px;">
                                        Your Potential Rebate
                                    </div>
                                @else
                                    <div class="col-md-12 text-center" style="font-weight: bolder; color: blue; margin-bottom: 10px;">
                                        &nbsp;
                                    </div>
                                @endif
                                <div class="col-md-12"  style="font-size: larger; font-weight: bolder;">
                                    @if (isset($rebateLevel->next_heigher_rebate_level))
                                        ${{ number_format($rebateLevel->minAmount) }} to ${{ number_format($rebateLevel->next_heigher_rebate_level->minAmount - 1) }}
                                    @else
                                        More than ${{ number_format($rebateLevel->minAmount) }}
                                    @endif
                                </div>
                                <div class="col-md-12">
                                    quarterly purchases
                                </div>
                                <div class="col-md-12">
                                    <span class="glyphicon glyphicon-arrow-down" aria-hidden="true" style="font-size: larger; margin-top: 10px; margin-bottom: 10px;"></span>
                                </div>
                                <div class="col-md-12" style="font-size: larger; font-weight: bolder;">
                                    {{ $rebateLevel->rebatePercent }}%
                                </div>
                                <div class="col-md-12" style="margin-bottom: 10px;">
                                    rebate
                                </div>
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->rebateBasedOnQTDVolume == $rebateLevel->rebatePercent)
                                    <div class="col-md-8 text-left" style="font-size: smaller;">
                                        Eligible Purchases: *
                                    </div>
                                    <div class="col-md-4 text-right" style="font-size: smaller;">
                                        ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->qualifiedPurchasesQTD) }}
                                    </div>
                                    <div class="col-md-8 text-left" style="font-size: smaller;">
                                        Estimated Rebate: <sup>&#8224;</sup>
                                    </div>
                                    <div class="col-md-4 text-right" style="font-size: smaller;">
                                        ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->rebateAmount) }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            <div class="col-md-4">
                <div class="panel panel-default"  style="height: 275px; border: 3px solid @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_quarterly_sales_valid) green @else darkred @endif;">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-12 text-center" style="height: 25px; font-size: larger; font-weight: bolder;">
                                Reach Quarterly Sales Goal
                            </div>
                            <div class="col-xs-12 text-center" style="height: 135px;">
                                <canvas id="gauge" style="width: 100%; height: 100%;"></canvas>
                            </div>
                            <div class="col-xs-7">
                                Quarterly Sales:
                            </div>
                            <div class="col-xs-5 text-right">
                                ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->QTD) }}
                            </div>
                            <div class="col-xs-12">
                                &nbsp;
                            </div>
                            <div class="col-xs-12 text-center" style="padding-top: 10px;">
                                @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_quarterly_sales_valid)
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->dollars_to_next_rebate_level) }} to reach the first rebate tier.
                                @elseif ((b2b()->activeCustomer()->parentCustomerRebateInformation->dollars_to_next_rebate_level))
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->dollars_to_next_rebate_level) }} to be eligible for the next rebate tier.
                                @else
                                    You have reached the maximum rebate tier.
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="panel panel-default" style="height: 275px; border: 3px solid @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) green @else darkred @endif;">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-12 text-center" style="height: 50px;  font-size: larger; font-weight: bolder;">
                                Return Rate under {{ b2b()->activeWebSilo()->required_rebate_return_percent }}%
                            </div>
                            <div class="col-xs-12 text-center" style="height: 110px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 75px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 75px; color: darkred;"></span>
                                @endif
                            </div>
                            <div class="col-xs-7">
                                Return Rate:
                            </div>
                            <div class="col-xs-5 text-right">
                                {{ b2b()->activeCustomer()->parentCustomerRebateInformation->YTD_RR }}%
                            </div>
                            @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                <div class="col-xs-12">
                                    &nbsp;
                                </div>
                                <div class="col-xs-12 text-center" style="padding-top: 10px;">
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->required_to_get_return_rate_below_cutoff) }} to get below {{ b2b()->activeWebSilo()->required_rebate_return_percent }}%
                                </div>
                            @else
                                <div class="col-xs-12">
                                    &nbsp;
                                </div>
                                <div class="col-xs-12 text-center" style="padding-top: 10px;">
                                    This criteria has been met.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            {{--<div class="col-md-3">--}}
                {{--<div class="panel panel-default" style="height: 275px; border: 3px solid @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_sales_valid) green @else darkred @endif;">--}}
                    {{--<div class="panel-body">--}}
                        {{--<div class="row">--}}
                            {{--<div class="col-xs-12 text-center" style="height: 50px; font-size: larger; font-weight: bolder;">--}}
                                {{--Stay Ahead of Last Year’s Sales--}}
                            {{--</div>--}}
                            {{--<div class="col-xs-12 text-center"  style="height: 110px;">--}}
                                {{--@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_sales_valid)--}}
                                    {{--<span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 75px; color: green;"></span>--}}
                                {{--@else--}}
                                    {{--<span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 75px; color: darkred;"></span>--}}
                                {{--@endif--}}
                            {{--</div>--}}
                            {{--<div class="col-xs-7">--}}
                                {{--Current YTD:--}}
                            {{--</div>--}}
                            {{--<div class="col-xs-5 text-right">--}}
                                {{--${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}--}}
                            {{--</div>--}}
                            {{--<div class="col-xs-7">--}}
                                {{--Last YTD:--}}
                            {{--</div>--}}
                            {{--<div class="col-xs-5 text-right">--}}
                                {{--${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->LYTD) }}--}}
                            {{--</div>--}}
                            {{--@if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_sales_valid)--}}
                                {{--<div class="col-xs-12">--}}
                                    {{--&nbsp;--}}
                                {{--</div>--}}
                                {{--<div class="col-xs-12 text-center" style="padding-top: 10px;">--}}
                                    {{--Spend ${{ number_format(-1 * b2b()->activeCustomer()->parentCustomerRebateInformation->variationYTD) }} to beat last years sales.--}}
                                {{--</div>--}}
                            {{--@else--}}
                                {{--<div class="col-xs-12">--}}
                                    {{--&nbsp;--}}
                                {{--</div>--}}
                                {{--<div class="col-xs-12 text-center" style="padding-top: 10px;">--}}
                                    {{--This criteria has been met.--}}
                                {{--</div>--}}
                            {{--@endif--}}
                        {{--</div>--}}
                    {{--</div>--}}
                {{--</div>--}}
            {{--</div>--}}
            <div class="col-md-4">
                <div class="panel panel-default" style="height: 275px; border: 3px solid @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_quarters_sales_valid) green @else darkred @endif;">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-12 text-center" style="height: 50px; font-size: larger; font-weight: bolder;">
                                Beat Last Year’s End of Quarter Sales
                            </div>
                            <div class="col-xs-12 text-center"  style="height: 110px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_quarters_sales_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 75px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 75px; color: darkred;"></span>
                                @endif
                            </div>
                            <div class="col-xs-8">
                                Current YTD:
                            </div>
                            <div class="col-xs-4 text-right">
                                ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}
                            </div>
                            <div class="col-xs-8">
                                Purchase Goal by {{ date('m-d-Y', b2b()->getEndOfCurrentQuarter(Carbon\Carbon::parse(\Marcolin\Models\CustomerRebateInformation::orderBy('date_modified', 'desc')->first()->date_modified)->timezone('America/New_York'))) }}:
                            </div>
                            <div class="col-xs-4 text-right">
                                ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->LYEQ_TOT) }}
                            </div>
                            @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_last_years_quarters_sales_valid)
                                <div class="col-xs-12 text-center" style="padding-top: 10px;">
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->LYEQ_TOT - b2b()->activeCustomer()->parentCustomerRebateInformation->YTD + 1) }} to beat last years end of quarter sales.
                                </div>
                            @else
                                <div class="col-xs-12 text-center" style="padding-top: 10px;">
                                    This criteria has been met.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 text-right" style="font-size: smaller;">
                (Updated on: {{ Carbon\Carbon::parse(\Marcolin\Models\CustomerRebateInformation::orderBy('date_modified', 'desc')->first()->date_modified)->timezone('America/New_York')->format('m/d/Y') }})
            </div>
            @if(b2b()->activeCustomer()->parentCustomerRebateInformation->has_rebate)
                <div class="col-md-12" style="font-size: smaller;">
                    * Eligible purchases exclude any purchases made at discount above the standard commercial policy. Contact your sales representatives for more details, and actual amounts accrued for the quarter.
                </div>
                <div class="col-md-12" style="font-size: smaller; padding-bottom: 15px;">
                    &#8224; All criteria must be met at the end of the quarter to qualify.
                </div>
            @endif
        </div>

        <script type="text/javascript">
            var labels = [];
            var staticZones = [];

            staticZones.push({
                strokeStyle: "#8b0000",
                min: 0,
                max: {{ b2b()->activeWebSilo()->rebateLevels()->orderBy('minAmount', 'asc')->first()->minAmount }}
            });

            @foreach(b2b()->activeWebSilo()->rebateLevels as $rebateLevel)
                labels.push({{ $rebateLevel->minAmount }});
                staticZones.push({
                    strokeStyle: "#{{ $rebateLevel->color }}",
                    min: {{ $rebateLevel->minAmount }},
                    max: {{ isset($rebateLevel->next_heigher_rebate_level) ? $rebateLevel->next_heigher_rebate_level->minAmount - 1 : 9999 }}
                });
            @endforeach

            var opts = {
                angle: 0, // The span of the gauge arc
                lineWidth: 0.3, // The line thickness
                radiusScale: .9, // Relative radius
                pointer: {
                    length: 0.55, // // Relative to gauge radius
                    strokeWidth: 0.025, // The thickness
                    color: '#000000' // Fill color
                },
                limitMax: false,     // If false, max value increases automatically if value > maxValue
                limitMin: true,     // If true, the min value of the gauge will be fixed
                staticLabels: {
                    font: "10px sans-serif",  // Specifies font
                    labels: labels,
                    color: "#000000",  // Optional: Label text color
                    fractionDigits: 0  // Optional: Numerical precision. 0=round off.
                },
                staticZones: staticZones,
                highDpiSupport: true,     // High resolution support
            };

            $(document).ready(function () {
                var target = document.getElementById('gauge'); // your canvas element
                var gauge = new Gauge(target).setOptions(opts); // create sexy gauge!
                gauge.maxValue = 10000; // set max gauge value
                gauge.animationSpeed = 32; // set animation speed (32 is default value)
                gauge.set({{ b2b()->activeCustomer()->parentCustomerRebateInformation->QTD }}); // set actual value
            });
        </script>

        <style>
            .grayout {
                opacity: 0.6; /* Real browsers */
                filter: alpha(opacity = 60); /* MSIE */
            }
        </style>
    @endif
@endif