@if(auth()->user())
    <div class="col-md-6">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title text-center">Rewards Status</h3>
            </div>
            <div class="panel-body" style="height: 280px">
                <div class="h4 text-center">
                    Your Marcolin Vision loyalty rewards level is:
                </div>
                <div class="rewardsBar">
                    <div class="one">ONE</div>
                    <div class="bronze">BRONZE</div>
                    <div class="silver">SILVER</div>
                    <div class="gold active">GOLD</div>
                    <div class="one platinum">PLATINUM</div>
                    <div class="clearfix"></div>
                </div>
                <br>
                <div>
                    <div class="pull-right h3 nomargin">$2,680</div>
                    <p>Last 12 months qualifying purchases: </p>
                </div>
                <div>
                    <div class="pull-right h3 nomargin">3</div>
                    <p>Last 12 months qualified categories: </p>
                </div>
                <div class="text-info">Continuous MarcolinVision Loyalty Rewards Program member since: 8/20/16</div>
                <a href="#" class="btn btn-info">Details</a>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="panel panel-info">
            <div class="panel-heading">
                <h3 class="panel-title text-center">Recent Orders</h3>
            </div>
            <div class="panel-body" style="height: 280px">
                <table class="table table-condensed">
                    <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Date</th>
                        <th>Qty.</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($lastOrders as $order)
                        <tr>
                            <td>{{ $order->marcolin_order_number }}</td>
                            <td>{{ $order->order_date }}</td>
                            <td>6</td>
                            <td>{{ $order->order_status }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @push('styles')
    <style type="text/css">
        .rewardsBar {
            width: 100%;
            padding-bottom: 10px;
        }

        .rewardsBar .one,
        .rewardsBar .bronze,
        .rewardsBar .silver,
        .rewardsBar .gold,
        .rewardsBar .platinum {
            width: 20%;
            float: left;
            text-align: center;
            margin-top: 18px;
            padding: 5px;
            vertical-align: bottom;
        }

        .rewardsBar .one {
            background-color: green;
            color: white;
        }

        .rewardsBar .bronze {
            background-color: darkred;
            color: white;
        }

        .rewardsBar .silver {
            background-color: slategray;
            color: white;
        }

        .rewardsBar .gold {
            background-color: gold;
        }

        .rewardsBar .platinum {
            background-color: lightgray;
        }

        .rewardsBar .active {
            height: 50px;
            padding-top: 18px;
            margin-top: 0px;
        }

    </style>
    @endpush
@endif