<?php

namespace Marcolin\Models;

use DB;


class AutocatCatalogItem extends UuidModel
{
    protected $table = "AutocatCatalogItems";

    protected static $morphMap = [
//        'webUnit' => WebUnit::class,
        'webStyle' => WebStyle::class,
//        'webBrand' => WebBrand::class,
    ];

    public static function getMorphMap()
    {
        return self::$morphMap;
    }

    public static function getItemClass($morphMapKey)
    {
        return array_get(self::$morphMap, $morphMapKey);
    }

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatCatalog_id', 'id');
    }

    public function item()
    {
        return $this->morphTo();
    }
}
