<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Marcolin\Listeners;

use Illuminate\Support\Facades\Mail;
use Marcolin\Events\OrderWasPlaced;

/**
 * Sends an order confirmation email to the customer.
 *
 * Class EmailOrderConfirmation
 * @package Marcolin\Listeners
 */
class EmailOrderConfirmation
{
    public function construct()
    {

    }

    public function handle(OrderWasPlaced $event)
    {
        $brandArray = [];
        foreach ($event->order->salesOrderItems()->with('unit.styleRelation.brand')->get() as $salesOrderItem) {
            $brandID = $salesOrderItem->unit->styleRelation->brand->id;
            $brandArray[$brandID] = $brandID;
        }

        $repEmailArray = [];
        foreach ($event->order->customer->activeSalesReps() as $salesRep) {
            $email = $salesRep->salesGroupEmail;
            foreach ($salesRep->brands as $brand) {
                if (in_array($brand->id, $brandArray) && !is_null($email) && strlen($email) > 0) {
                    $repEmailArray[$email] = $email;
                    break;
                }
            }
        }

        $toEmailList = [];
        if (config('app.debug') === false) {
            foreach ($event->order->customer->webUsers as $webUser) {
                if (strlen($webUser->email)) $toEmailList[strtoupper($webUser->email)] = $webUser->email;
            }
        }
        foreach (config('marcolin.emailDestinations.orderConfirmation.to', []) as $to) {
            if (strlen($to)) $toEmailList[strtoupper($to)] = $to;
        }

        $bccEmailList = [];
        if (config('app.debug') === false) {
            $bccEmailList = $repEmailArray;
        }
        foreach (config('marcolin.emailDestinations.orderConfirmation.bcc', []) as $bcc) {
            if (strlen($bcc)) $bccEmailList[strtoupper($bcc)] = $bcc;
        }

        if (count($toEmailList) > 0 || count($bccEmailList) > 0) {
            Mail::send('marcolin::emails.orders.confirmation', ['order' => $event->order, 'url' => config('marcolin.b2b.url')], function ($email) use ($event, $toEmailList, $bccEmailList) {
                foreach ($toEmailList as $to) {
                    $email->to($to);
                }

                foreach ($bccEmailList as $bcc) {
                    $email->bcc($bcc);
                }

                $email->from(config('mail.from_orders.address'), config('mail.from_orders.name'));

                if ($event->order->orderType === 'B') {
                    $email->subject(trans('marcolin::email.orderConfirmationSubjectB2B', ['orderNumber' => $event->order->orderNumber, 'customerNumber' => $event->order->customer->customerCode]));
                } else {
                    $email->subject(trans('marcolin::email.orderConfirmationSubjectESB', ['orderNumber' => $event->order->orderNumber, 'customerNumber' => $event->order->customer->customerCode]));
                }
            });
        }
    }
}