<?php

namespace Marcolin\Models;

/**
 * Class PromotionOrderQuantityTrigger_Product
 * @package Marcolin\Models
 */
class PromotionOrderQuantityTrigger_Product extends WebModel {
    protected $table = 'PromotionOrderQuantityTrigger_Product';
    protected $fillable = [
        'promotionorderquantitytrigger_id',
        'product_id', 'product_type',
        'is_excluded',
    ];
    protected $casts = ['is_excluded' => 'boolean'];

    /**
     * Gets the relationship to the owning PromotionOrderQuantityTrigger row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCurrentOrderValueTrigger() {
        return $this->belongsTo(PromotionOrderQuantityTrigger::class,
            'promotionorderquantitytrigger_id', 'id');
    }


    // Scopes
    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionorderquantitytrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }
}