<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Image as Image2;
use Storage;

/**
 * Marcolin\Models\Product
 *
 * @property mixed $id
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\Unit whereId($value)
 */
class Unit extends WebModel
{
	protected $table = 'Units';

    const IN_STOCK = '';
    const OUT_OF_STOCK = '0';
    const DELAYED = '2';
    const UNKNOWN = 'unknown';

    function style() {
        return $this->belongsTo(Style::class);
    }

    function webStyle() {
        return $this->hasOne(WebStyle::class, 'style_id', 'style_id');
    }

	public function webUnit() {
		return $this->hasOne(WebUnit::class);
	}

    public function getColorInfoAttribute() {
        return $this->color .' - '. $this->colorDescription;
    }

    public function priceListValues() {
        return $this->hasMany(PriceListValue::class);
    }

    public function getCustomerPrice($customer) {
        $priceListValue = $this
                ->priceListValues
                ->where('priceList_id', $customer->priceList_id)
                ->where('currency', $customer->currency)
                ->first();

        if (isset($priceListValue)) {
            return $priceListValue->materialOpticalPrice / 100;
        } else {
            return 0;
        }
    }

    public function getCustomerDiscountAttribute() {
        return 0;
    }


    public function primaryImage($width = false, $height = false) {
        return $this->webUnit->primaryImage($width, $height);
    }

    public function scopeWebVisible(Builder $query) {
        return $query
            ->where('salesOrg', '=', b2b()->activeSalesOrg())
            ->whereNotIn('productSalesStatus_id', [2, 3, 5, 6])
            ->where(function($query) {
                $query
                    ->where('closeOutDate', '=', '0000-00-00')
                    ->orWhereRaw('closeOutDate > date_sub(now(), interval 60 day)')
                ;
            })
        ;
    }
}

