<?php

namespace Marcolin\Models;

use Illuminate\Support\Facades\DB;


class AutocatCatalog extends UuidModel
{
    protected $table = "AutocatCatalogs";

    public function autocatCatalogItems()
    {
        return $this->hasMany(AutocatCatalogItem::class, 'autocatCatalog_id', 'id');
    }

    public function autocatLayout()
    {
        return $this->belongsTo(AutocatLayout::class, 'autocatLayout_id', 'id');
    }

    public function webUser()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function getCatalogIdStringAttribute() {
        return DB::selectOne('SELECT UuidFromBin(id) as id FROM AutocatCatalogs WHERE id = ?', [$this->id])->id;
    }

    public function getNameCleanAttribute() {
        $name = $this->name;

        preg_replace("/[^A-Za-z0-9]+/", '_', $name);

        return "$name.pdf";
    }

    public function getFilenameAttribute() {
        return "$this->idString.pdf";
    }
}
