<?php

namespace Marcolin\Models;

use DB;
use Marcolin\Models\SelectsRelatedCount;

class WebAttributeFilter extends WebModel
{
	protected $table = 'WebAttributeFilters';
	protected $fillable = ['filterable_type', 'filterable_id', 'webattribute_id', 'display_as', 'filter_values'];

	public function filterable() {
		return $this->morphTo();
	}

	public function webAttribute() {
		return $this->belongsTo(WebAttribute::class, 'webattribute_id', 'id');
	}

	public function webAttributeFilterValues() {
		return $this->hasMany(WebAttributeFilterValue::class, 'webattributefilter_id');
	}

	public function setFilterValuesAttribute($valuesArray) {
		$this->save();
		$this->webAttributeFilterValues()->delete();
		foreach ($valuesArray as $value) {
			$filterValue = new WebAttributeFilterValue(['filter_value' => $value]);
			$this->webAttributeFilterValues()->save($filterValue);
		}
	}
}