<?php

namespace Marcolin\Models;

use Auth;
use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSilo extends WebModel implements HasLandingPageInterface
{
    protected $table = "WebSilos";
    protected $fillable = ['contactus_id', 'name', 'slug', 'webRoleIds', 'is_visible', 'is_default', 'detail', 'default_price_list', 'contact_phone', 'contact_email', 'weblandingpage_id'];
    protected $casts = [
        'is_visible' => 'boolean'
    ];

    public function webBrands()
    {
        return $this->belongsToMany(WebBrand::class, 'WebBrand_WebSilo', 'websilo_id', 'webbrand_id')
            ->withPivot('sort_name')
            ->with('brand')
            ->orderBy('sort_name');
    }

    public function visibleWebBrands()
    {
        return $this
            ->webBrands()
            ->visible()
            ->forDisplay();
    }

    public function contactUs()
    {
        return $this->belongsTo(WebContactUs::class, 'contactus_id', 'id');
    }

    public function webLinkCategories()
    {
        return $this->belongsToMany(WebCategory::class, 'WebLinkCategory_WebSilo', 'websilo_id', 'weblinkcategory_id');
    }

    public function webLinks()
    {
        return $this->belongsToMany(WebCategory::class, 'WebLink_WebSilo', 'websilo_id', 'weblink_id');
    }

    public function webUrls()
    {
        return $this->hasMany(WebUrl::class, 'websilo_id', 'id');
    }

    public function customers() {
        return $this->belongsToMany(Customer::class, 'Customer_WebSilo', 'websilo_id', 'customer_id')
            ->withPivot(['can_order_hilco_parts', 'can_order_silo_parts', 'require_approval_hilco_parts', 'require_approval_silo_parts'])
            ;
    }

    public function webLandingPageWebSiloJoins() {
        return $this->hasMany(WebLandingPage_WebSilo::class, 'websilo_id', 'id');
    }

    public function getWebLandingPageAttribute() {
        $activePlantId = '';
        $joins = $this->webLandingPageWebSiloJoins->keyBy('plant_id');
        $landingPage = array_get($joins, "$activePlantId.webLandingPage", array_get($joins, "-1.webLandingPage"));
        return $landingPage;
    }

    public function getFeaturedChildrenAttribute()
    {
        return $this->visibleWebBrands()->wherePivot('is_featured', 1)->get();
    }

    public function getChildrenAttribute()
    {
        return $this->visibleWebBrands()->get();
    }

    public function divisionRules()
    {
        return $this->belongsToMany(Division::class, 'WebSilo_Division', 'websilo_id', 'division_id');
    }

    public function customerCategorySummaryRules()
    {
        return $this->belongsToMany(CustomerCategorySummary::class, 'WebSilo_CustomerCategorySummary', 'websilo_id', 'customercategorysummary_id');
    }

    public function webCustomerTypeRules()
    {
        return $this->belongsToMany(WebCustomerType::class, 'WebSilo_WebCustomerType', 'websilo_id', 'webcustomertype_id');
    }

    public function getDivisionsAttribute()
    {
        return $this->divisionRules->pluck('id')->toArray();
    }

    public function setDivisionsAttribute($ids)
    {
        $this->divisionRules()->sync($ids);
    }

    public function getCustomerCategorySummariesAttribute()
    {
        return $this->customerCategorySummaryRules->pluck('id')->toArray();
    }

    public function setCustomerCategorySummariesAttribute($ids)
    {
        $this->customerCategorySummaryRules()->sync($ids);
    }

    public function getWebCustomerTypesAttribute()
    {
        return $this->webCustomerTypeRules->pluck('id')->toArray();
    }

    public function setWebCustomerTypesAttribute($ids)
    {
        $this->webCustomerTypeRules()->sync($ids);
    }

    public function getUrlsAttribute()
    {
        return $this->webUrls->pluck('id')->toArray();
    }

    public function setUrlsAttribute($ids)
    {
        $this->webUrls()->sync($ids);
    }

    public function scopeVisible(Builder $query)
    {
        return $query->where('WebSilos.is_visible', '1');
    }

    public function scopeCurrent(Builder $query)
    {
        $query->where('id', b2b()->activeWebSilo()->id);
    }

    public function getPriceListAttribute()
    {
        return 'Catalog';
    }

    public function slugUrl()
    {
        return route('silo.slug', [$this->slug]);
    }

    use HasAssets, HasSlug, HasLandingPage, RevisionableTrait;

    public function getParentRelationName()
    {
        return false;
    }
}
