<?php
/**
 * Created by PhpStorm.
 * User: dave
 * Date: 4/30/2015
 * Time: 4:09 PM
 */

namespace Marcolin\Models\Scopes;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\ScopeInterface;
use Illuminate\Database\Query\Expression;
use Illuminate\Support\Facades\Auth;

class RestrictableScope implements ScopeInterface{

    private $wheres = [];

    public function apply(Builder $builder, Model $model) {
        if(isset($builder->getQuery()->wheres)) {
            $this->wheres = array_merge($this->wheres, $builder->getQuery()->wheres);
        } else {
            $this ->wheres = [];
        }
        $builder->whereHas('restrictions',function($q){
            if(Auth::check()) {
                $rIDs = Auth::user()->webRoles->pluck('id');
                $q->whereIn('webRole_id', $rIDs);
            }
        },'=',0);
        $this->wheres = $this->getNewWheres($builder->getQuery()->wheres, $this->wheres);

    }

    public function remove(Builder $builder, Model $model) {
        $query = $builder->getQuery();

        foreach ((array) $query->wheres as $key => $where)
        {
            // If the where clause is a soft delete date constraint, we will remove it from
            // the query and reset the keys on the wheres. This allows this developer to
            // include deleted model in a relationship result set that is lazy loaded.
            if (self::arrayHasWhereStatement($this->wheres, $where))
            {
                unset($query->wheres[$key]);
                $query->wheres = array_values($query->wheres);
            }
        }

    }

    private function getNewWheres($new, $original) {
        $newWheres = [];
        foreach($new as $newWhere) {
            if(!self::arrayHasWhereStatement($original, $newWhere)) {
                $newWheres[] = $newWhere;
            }
        }
        return $newWheres;
    }

    private static function arrayHasWhereStatement($array, $where) {
        foreach($array as $_where) {
            if(self::compareWhereStatement($where, $_where)) {
               return true;
            }
        }
    }

    private static function compareWhereStatement($a, $b) {
//        var_dump($a);
//        var_dump($b);
//        die;
        if(
           $a['type'] === $b['type']
           && $a['boolean'] === $b['boolean']
           &&
           (
                ($a['type'] === 'Basic' &&
                    self::whereParameterValue($a,'column') === self::whereParameterValue($b,'column') &&
                    self::whereParameterValue($a,'operator') === self::whereParameterValue($b,'operator') &&
                    self::whereParameterValue($a,'value') === self::whereParameterValue($b,'value'))
                ||
                ($a['type'] === 'In' &&
                    self::whereParameterValue($a,'column') === self::whereParameterValue($b,'column') &&
                    self::whereParameterValue($a,'values') === self::whereParameterValue($b,'values'))
                ||
                ($a['type'] === 'Nested' &&
                 $a['query'] === $b['query'])
                ||
                ($a['type'] === 'raw' &&
                    $a['sql'] === $b['sql'])
           )
        ) {
            return true;
        } else {
            $isBasic = $a['type'] === 'Basic';
            if ($isBasic && $a['type'] === $b['type'] ){
                $columnMatch = $a['column']  === $b['column'];
                $aOpSet = isset($a['operator']);
                $bOpSet = isset($b['operator']);
                $opMatch = $a['operator'] === $b['operator'];
                $aValSet = isset($a['value']);
                $bValSet = isset($b['value']);
                $valMatch = $a['value'] === $b['value'];
            }
            return false;
        }
    }

    private static function whereParameterValue($whereStatement, $parameter){
        if (isset($whereStatement[$parameter])){
            if ($whereStatement[$parameter] instanceof Expression){
                return $whereStatement[$parameter]->getValue();
            }else{
                return $whereStatement[$parameter];
            }
        }else{
            return null;
        }
    }
}