<?php

namespace Marcolin\Models;

use DB;


class CustomerRebateInformation extends WebModel {
    protected $table = "CustomerRebateInformation";
    protected $fillable = [
        'customerCode', 'customerCode_id', 'custName', 'customerGroup09',
        'salesDistrict', 'districtManager',
        'street', 'city', 'state', 'zip', 'phone',
        'QTD', 'LYEQ_TOT', 'YTD', 'LYTD', 'variationYTD', 'YTD_RR', 'qualifiedPurchasesQTD', 'rebateBasedOnQTDVolume',
        'required_to_get_return_rate_below_cutoff', 'rebateAmount',
        'commit_sequence'
    ];

    public function customers() {
        return $this->hasMany(Customer::class, 'customerCode_id', 'customerCode_id');
    }

    public function getDollarsToNextRebateLevelAttribute($webSilo = false) {
        if (!$webSilo) {
            $webSilo = b2b()->activeWebSilo();
        }

        $rebateLevel = $webSilo->rebateLevels()->where('minAmount', '>', $this->QTD)->orderBy('minAmount', 'ASC')->first();
        if (isset($rebateLevel)) {
            return $rebateLevel->minAmount - $this->QTD;
        } else {
            return false;
        }
    }

    public function getHasRebateAttribute() {
        return $this->rebateBasedOnQTDVolume > 0;
    }


    public function getIsQuarterlySalesValidAttribute($webSilo = false) {
        if (!$webSilo) {
            $webSilo = b2b()->activeWebSilo();
        }

        $rebateLevelCount = $webSilo->rebateLevels()->where('minAmount', '<=', $this->QTD)->count();
        if ($rebateLevelCount > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function getIsLastYearsSalesValidAttribute() {
        return $this->YTD > $this->LYTD;
    }

    public function getIsLastYearsQuartersSalesValidAttribute() {
        return $this->YTD > $this->LYEQ_TOT;
    }

    public function getIsReturnRateValidAttribute() {
        return $this->required_to_get_return_rate_below_cutoff <= 0;
    }
}
